pro bin_cohen_spec,cohen_lambda,cohen_flux,cohen_d_flux,wave_array,cohen_flux_bin,cohen_d_flux_bin

  n_wave=n_elements(wave_array)
  cohen_flux_bin=fltarr(n_wave) & cohen_d_flux_bin=fltarr(n_wave)

  for i=1,n_wave-1-1 do begin
     if NG() || LG2() then begin ; negative dispersion!
        bin1=max(where(cohen_lambda LE wave_array[i]-((wave_array[i-1]-wave_array[i])/2.),count1))+1
        bin2=min(where(cohen_lambda GT wave_array[i]+((wave_array[i]-wave_array[i+1])/2.),count2))-1
     endif else begin
        bin1=max(where(cohen_lambda LE wave_array[i]-((wave_array[i]-wave_array[i-1])/2.),count1))+1
        bin2=min(where(cohen_lambda GT wave_array[i]+((wave_array[i+1]-wave_array[i])/2.),count2))-1
     endelse
     
     case 1 of
        (count1 GT 0 && count2 GT 0 && bin2 GT bin1+2): flux_interp=total(cohen_flux[bin1:bin2])/float(bin2-bin1+1.)
        (count1 GT 0 && count2 GT 0 && bin2 LE bin1+2): linterp,cohen_lambda,cohen_flux,wave_array[i],flux_interp
        (count1 EQ 0 || count2 EQ 0):                   linterp,cohen_lambda,cohen_flux,wave_array[i],flux_interp
     endcase
     
     cohen_flux_bin[i]=flux_interp
     
     linterp,cohen_lambda,cohen_d_flux,wave_array[i],d_flux_interp
     cohen_d_flux_bin[i]=d_flux_interp
  endfor
  
end
