pro calc_slitwidth,refimage_ds

  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

; note: run the pipeline with /no_fov_mask option

;  slit_area_2d=refimage_ds[92:118,188:227] ; for Ns on NIR
  slit_area_2d=refimage_ds[0:45,188:227] ; for Nh on NIR
;  slit_area_2d=refimage_ds[5:19,115:135,0] ; for Ns on MIRS
;  slit_area_2d=refimage_ds[246:255,122:145,0] ; for Ls
  
  slit_profile=total(slit_area_2d,1)
  s=size(slit_area_2d) & ysize=s[2]
  slit_profile=fltarr(ysize)

  for y=0,ysize-1 do begin
;     slit_profile[y]=median(slit_area_2d[*,y])
     meanclip_mod,slit_area_2d[*,y],avg
     slit_profile[y]=avg
  endfor

  result=mpfitpeak(findgen(ysize),slit_profile,A,nterms=5)
  
  plot,slit_profile,color=white,psym=10
  oplot,result,color=red
  
  print,'FWHM of a slit (pix): ',A[2]*2.355
  
end
