pro calc_system_throughput,response_lambda,eff

h=6.63e-34 & c=3e8
; 1 Jy =1e-26 W/m2/Hz

set_response,response_lambda,response,d_response

shift_wavelength,response_lambda,1.,response_lambda_shift
;xarray=findgen(n_elements(response))
;linterp,xarray,response_lambda,xarray+1.,response_lambda_shift
d_lambda=abs(response_lambda_shift-response_lambda) ; in um
print,'mean(d_lambda)=',mean(d_lambda)

eff=response                    ; count/Jy
eff=eff/!IRC_SPECRED_CHIPINFO.exptime ; count/Jy -> (count/sec)/Jy
eff=eff*!IRC_SPECRED_CHIPINFO.ADG ; (count/sec)/Jy -> (electron/sec)/Jy
eff=eff/(1e-26/1e4*c/(response_lambda*1e-6)^2./1e6) ; (electron/sec)/Jy -> (electron/sec)/(W cm-2 um-1)
eff=eff/((68.5/2.)^2.*!pi*d_lambda) ; (electron/sec)/(W cm-2 um-1) -> (electron/sec)/W
eff=eff*(h*c/(response_lambda*1e-6)) ; (electron/sec)/W -> (electron/sec)/(photon/sec)

plot,response_lambda,eff,color=!IRC_SPECRED_COLOR.white,psym=10

end
