pro compare_space_profile,refimage_n_bg,specimage_n_wc,source_id,wave_array,x1=x1,x2=x2

  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

  if defined(x1) then !x.range=[x1,x2] else !x.range=0

; refimag space profile
  refimage_tmp=refimage_n_bg[*,*,source_id]
  s=size(refimage_tmp) & xsize=s[1] & ysize=s[2]

  refimage_cut_v=refimage_tmp[xsize/2,*]
  peak_pos=where(refimage_cut_v EQ max(refimage_cut_v))

  refimage_cut=refimage_tmp[*,peak_pos]

  refimage_cut_norm=refimage_cut/max(refimage_cut)
  fit_refimage=mpfitpeak(findgen(xsize),refimage_cut_norm,B,nterms=5,perror=perror,bestnorm=bestnorm,dof=dof)
  PCERROR_ref = PERROR * SQRT(BESTNORM / DOF) ; scaled uncertainties
  plot,findgen(xsize),refimage_cut_norm,color=white,psym=10
  oplot,fit_refimage,color=white
  print,'refimage FWHM size (pix)=',B[2]*2.355
  
; spec space profile
  specimage_tmp=specimage_n_wc[*,*,source_id]
  s=size(specimage_tmp) & xsize=s[1] & ysize=s[2]

  every=4

  fwhm=fltarr(ysize/every+7)
  wave_array_sparse=fltarr(ysize/every+7)
  fwhm_error=fltarr(ysize/every+7)
  peak_pos=fltarr(ysize/every+7)
  k=0

  for y=every,ysize-every-1,every do begin
     specimage_cut=specimage_tmp[7:xsize-7,y-every:y+every]
     specimage_cut_1d=total(specimage_cut,2)
     specimage_cut_norm=specimage_cut_1d/max(specimage_cut_1d)
     fit_spec=mpfitpeak_nan(findgen(xsize-14),specimage_cut_norm,A,nterms=5,perror=perror,bestnorm=bestnorm,dof=dof)
;    DOF     = xsize - 5 ; deg of freedom
     PCERROR = PERROR * SQRT(BESTNORM / DOF) ; scaled uncertainties
     oplot,findgen(xsize-14)+7,specimage_cut_norm,color=red,psym=10
     oplot,findgen(xsize-14)+7,fit_spec,color=red
     fwhm[k]=A[2]*2.355
     fwhm_error[k]=pcerror[2]*2.355
     wave_array_sparse[k]=wave_array[y]
     peak_pos[k]=A[1]+7
     k+=1
;    print,'specimage FWHM size (pix)=',A[2]*2.355
  endfor

  fwhm=fwhm[0:k-1]
  fwhm_error=fwhm_error[0:k-1]
  wave_array_sparse=wave_array_sparse[0:k-1]
  peak_pos=peak_pos[0:k-1]
  
  plot,wave_array_sparse,fwhm,color=black,psym=10,yrange=[0,6],xtitle='Wavelength (um)',ytitle='FWHM (pix)',xrange=!IRC_SPECRED_SPECPARAM.w_cover_2
  err_plot,wave_array_sparse,fwhm-fwhm_error,fwhm+fwhm_error,color=black
  
  oplot,[2.43],[4.26/!IRC_SPECRED_CHIPINFO.pixscale_nir_x],psym=5,color=red
  oplot,[3.16],[3.99/!IRC_SPECRED_CHIPINFO.pixscale_nir_x],psym=5,color=red
  oplot,[4.14],[4.18/!IRC_SPECRED_CHIPINFO.pixscale_nir_x],psym=5,color=red
  
  oplot,[7.3],[5.06/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x],psym=5,color=red
  oplot,[9.1],[5.52/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x],psym=5,color=red
  oplot,[10.7],[4.80/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x],psym=5,color=red
  
  oplot,[15.7],[5.69/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x],psym=5,color=red
  oplot,[18.3],[5.66/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x],psym=5,color=red
  oplot,[23.0],[6.83/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x],psym=5,color=red

  oplot,[2.43],[2.95],psym=5,color=blue
  oplot,[3.16],[3.04],psym=5,color=blue
  oplot,[4.14],[2.81],psym=5,color=blue
  
  oplot,[7.3],[2.26],psym=5,color=blue
  oplot,[9.1],[2.17],psym=5,color=blue
  oplot,[10.7],[2.10],psym=5,color=blue
  
  oplot,[15.7],[2.31],psym=5,color=blue
  oplot,[18.3],[2.58],psym=5,color=blue
  oplot,[23.0],[3.02],psym=5,color=blue
  
  lambda=findgen(26)
  diff_limit=lambda*1.22*1e-6/0.70*206265/2.355
  oplot,lambda,diff_limit,color=blue

  oplot,[3.16],[B[2]*2.355],psym=4,color=green
  oplot,[9.1],[B[2]*2.355],psym=4,color=green
  oplot,[18.3],[B[2]*2.355],psym=4,color=green

  err_plot,[3.16],[B[2]*2.355-pcerror_ref[2]*2.355],[B[2]*2.355+pcerror_ref[2]*2.355],color=green
  err_plot,[9.1],[B[2]*2.355-pcerror_ref[2]*2.355],[B[2]*2.355+pcerror_ref[2]*2.355],color=green
  err_plot,[18.3],[B[2]*2.355-pcerror_ref[2]*2.355],[B[2]*2.355+pcerror_ref[2]*2.355],color=green
  
;  atv,specimage_tmp,/b
;  set_color,/white_bg

; plot,peak_pos,color=black,yr=[14,18],psym=10

end
