pro irc_wavesol,spec2d,source_id,smooth=smooth

; Make wavelength solution by identify/fitcoord

  COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

  !P.charsize=1 & !Y.range=[0,0]
  
  if defined(source_id) EQ 0 then source_id=0
  
  s=size(spec2d) & ysize=s[1]
  
  if keyword_set(smooth) then spec2d_plot=poly_smooth(spec2d,3) else spec2d_plot=spec2d
  
; set wave range for plot purpose only
  w_cover_show=!IRC_SPECRED_SPECPARAM.w_cover
  w_cover_show[0]=!IRC_SPECRED_SPECPARAM.w_cover[0]-(!IRC_SPECRED_SPECPARAM.w_cover[1]-!IRC_SPECRED_SPECPARAM.w_cover[0])*0.2 ; add extra margin
  w_cover_show[1]=!IRC_SPECRED_SPECPARAM.w_cover[1]+(!IRC_SPECRED_SPECPARAM.w_cover[1]-!IRC_SPECRED_SPECPARAM.w_cover[0])*0.2
  
  max_line=30
  lambda_measured=fltarr(max_line) & lambda_input=fltarr(max_line) ; initialize
  xarray_measured=fltarr(max_line) & lambda_error=fltarr(max_line)
  xarray=findgen(ysize)
  
  wavelength=wavelength_func()
  
  window,1,xsize=500,ysize=400,title='Observed Spectrum'
  window,2,xsize=500,ysize=400,title='Fitting Window '
  window,3,title='Wavelength Fit Solution',xsize=500,ysize=400
  window,4,title='Wavelength Calibrated Spectrum',xsize=500,ysize=400
  
  line_id=0
  while (1) do begin
     wset,1
     plot,wavelength,spec2d_plot[*,source_id], $
          /ynozero,xrange=[w_cover_show[0],w_cover_show[1]],xstyle=1,psym=10,color=white
     print,'Click' & cursor,x1,y1 & wait,0.2 & print,'Click again' & cursor,x2,y2 ; read cursor pos.
     fitrange=where(wavelength GT x1 and wavelength LT x2, count) ; get fit range array ID
     if count LE 3 then begin
        fitrange=[fitrange[0]-1,fitrange,fitrange[n_elements(fitrange)-1]+1] ; expand range if too short
        if fitrange[0] LT 0 then $
           fitrange=shift(fitrange,-min(fitrange)) ; shift positively if fitrange is too low
        if fitrange[n_elements(fitrange)-1] GT n_elements(wavelength)-1 then $
           fitrange=shift(fitrange,-((n_elements(fitrange)-1)-(n_elements(wavelength)-1)))
                                ; shift negatively if fitrange is too high
     endif
     
; Gauss peak fit (with mpfitpeak function)
;       linefit=mpfitpeak(wavelength[fitrange],spec2d_plot[fitrange,source_id],coef, $
     linefit=mpfitpeak(xarray[fitrange],spec2d_plot[fitrange,source_id],coef, $
                       nterms= ((n_elements(fitrange)-1)> 3 < 5), /positive)
     xarray_measured[line_id]=coef[1]
     
     linefit_tmp=mpfitpeak(wavelength[fitrange],spec2d_plot[fitrange,source_id],coef_tmp, $
                           nterms= ((n_elements(fitrange)-1)> 3 < 5), /positive,dof=dof,perror=perror,bestnorm=bestnorm)
     if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,0.,0.,0.,0.,0.]
     lambda_measured[line_id]=coef_tmp[1]
     lambda_error[line_id]=error[1]
     
; Parabora peak fit
;
; 1st attempt
;        coef=robust_poly_fit( $
;                          wavelength[fitrange],spec2d_plot[fitrange,source_id],2, $
;                          linefit,sig)
;        peak=-(coef[1]/coef[2]/2.)
;;       peak=total(wavelength[fitrange]*spec2d_plot[fitrange,source_id])/total(spec2d_plot[fitrange,source_id])
;
; 2nd attempt
;        fitrange2=fitrange      ; dummy for consistensy with parabora peak fit routine
;        fitrange2=where( wavelength GT peak-3*wavescale $
;                         and $
;                         wavelength LT peak+3*wavescale)
;        coef=robust_poly_fit( $
;                          wavelength[fitrange2],spec2d_plot[fitrange2,source_id],2, $
;                          linefit,sig)
;
;        lambda_measured[line_id]=-(coef[1]/coef[2]/2.)
   
; end of peak find
   
; plot fit results
     wset,2
     plot,xarray[fitrange],linefit,psym=0,color=white,/ynozero
     oplot,xarray,spec2d_plot[*,source_id],psym=10,color=red
     oplot,[xarray_measured[line_id], xarray_measured[line_id]],[-1e10,1e10],linestyle=2,color=green
     
     print,'Lambda= ',lambda_measured[line_id],' (um)', ' at ',xarray_measured[line_id]
;repeat_input:
     lambda_input_tmp=0.0       ; float dummy
     read,lambda_input_tmp,prompt='Input wavelength of this line (um): '
     lambda_input[line_id]=float(lambda_input_tmp)
     
     do_iteration='dummy'       ; dummy
     read,do_iteration,prompt='Fit another line ? [y/n] '
     if do_iteration EQ 'n' or do_iteration EQ 'N' or do_iteration EQ 'NO' or do_iteration EQ 'no' then break
     line_id+=1
  endwhile                      ; of line fit and input
  
  lambda_input=lambda_input[0:line_id]
; lambda_measured=lambda_measured[0:line_id]
  xarray_measured=xarray_measured[0:line_id]
  lambda_error=lambda_error[0:line_id]

; wave_solution fitting
  dialog_list_array=(string(lambda_input) + string(xarray_measured))
  result=dialog_checklist(dialog_list_array,/NONEXCLUSIVE,title='Check lines for fitting')
  use_array=where(result EQ 1)
  
; 1D fit
; wavesolconf=robust_poly_fit(xarray_measured[use_array],lambda_input[use_array],1,wavesolfit,sig)
  wavesolconf=poly_fit(xarray_measured[use_array],lambda_input[use_array],1,yfit=wavesolfit,sigma=sig,measure_errors=lambda_error[use_array])
  wavelength_fit=xarray*wavesolconf[1]+wavesolconf[0]
; 2D fit
  wavesolconf2=robust_poly_fit(xarray_measured[use_array],lambda_input[use_array],2,wavesolfit2,sig2)
  wavelength_fit2=xarray*xarray*wavesolconf2[2]+xarray*wavesolconf2[1]+wavesolconf2[0]
  
;   wavesolconf=robust_poly_fit(lambda_measured[use_array],lambda_input[use_array],1,wavesolfit,sig)
;   wavelength_fit_tmp=wavelength*wavesolconf[1]+wavesolconf[0]
;   wavesolconf2=robust_poly_fit(xarray,wavelength_fit_tmp,1,wavesolfit,sig)
;   wavelength_fit=xarray*wavesolconf2[1]+wavesolconf2[0]
  
; Wave solution fit results
  wset,3
;   plot,lambda_measured[use_array],lambda_input[use_array],psym=5,/ynozero,xstyle=2,color=white
;   oplot,lambda_measured,wavesolfit,psym=0,color=white
;   ymax=max(wavelength_fit) & ymin=min(wavelength_fit)
  ymax=!IRC_SPECRED_SPECPARAM.w_cover[1] & ymin=!IRC_SPECRED_SPECPARAM.w_cover[0]
  plot,xarray_measured[use_array],lambda_input[use_array],psym=5,xstyle=1,ystyle=2,color=white, $
       xrange=[0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy],yrange=[ymin,ymax], $
       xtitle='dY (pixel)',ytitle='Wavelength (um)'
  oplot,wavelength_fit,psym=0,color=green
  
  wset,4
  plot,wavelength_fit,spec2d_plot[*,source_id], $
       xrange=[w_cover_show[0],w_cover_show[1]],color=white,psym=10 ; spectrum with correct wavelength
  
; for linear fit
  print,'1st order fit result: lambbda_0=',wavelength_fit[(ysize-1)/2-!IRC_SPECRED_SPECEXTRACTPARAM.y_offset],'+-',sig[0], $
        ': dispersion=', wavesolconf[1],'+-',sig[1], $
        ': lambda at zero pix=',wavelength_fit[0],'+-',sig[0], $
        ': lambda error in pix=',sig[0]/wavesolconf[1]
;,': fitting error= ',sig     
  
; for 2nd order fit
  print,'2nd order fit result: ',wavesolconf2[2],wavesolconf2[1],wavesolconf2[0]

end
