pro make_pseudo_sky,specimage,mask_specimage,pseudo_sky2d,sigma

common CHIP_DIMS,ncol_nir,nrow_nir,ncol_mir,nrow_mir
common frame_type,chip,filter,grism
common dir_structure,datadir,calibdir

pseudo_sky2d=specimage          ; dummy setting

if chip EQ 0 then begin
    xsize=ncol_nir
    ysize=nrow_nir
endif else begin
    xsize=ncol_mir
    ysize=nrow_mir
endelse

xarray=indgen(xsize)

for i=0,ysize-1 do begin
    use_array=where(mask_specimage[*,i] NE 0,count)
    coef=robust_poly_fit(xarray[use_array],specimage[use_array,i],2,fit_tmp,sigma)
    pseudo_sky2d[*,i]=coef[0]+coef[1]*xarray+coef[2]*xarray^2
endfor

if chip EQ 0 and grism EQ 0 then skyname='SKY_NP.fits'
if chip EQ 1 and grism EQ 0 then skyname='SKY_SG1.fits'
if chip EQ 1 and grism EQ 1 then skyname='SKY_SG2.fits'
if chip EQ 2 and grism EQ 1 then skyname='SKY_LG2.fits'

pseudo_sky_filename=CALIBDIR+'SKY/'+skyname
 
mwrfits,pseudo_sky2d,pseudo_sky_filename

end
