pro make_slitflat,image,chip,grism,image_with_slitflat;_nan

; set range
  if chip EQ 0 && grism EQ 0 then begin
     x1=200 & x2=280 & y1=399 & y2=426
  endif
  if chip EQ 0 && grism EQ 1 then begin
     x1=00 & x2=295 & y1=420 & y2=455
  endif
  if chip EQ 1 && grism EQ 0 then begin
     x1=9 & x2=23 & y1=90 & y2=170
  endif
  if chip EQ 1 && grism EQ 1 then begin
     x1=9 & x2=18 & y1=90 & y2=170
  endif
  if chip EQ 2 then begin
     x1=245 & x2=255 & y1=100 & y2=170
  endif
  
  image_slit=image[x1:x2,y1:y2]
  image_slit=sigma_filter(image_slit,radius=1,/all,/iterate)
  
  s=size(image_slit) & xsize=s[1] & ysize=s[2]
  image_slit_2d_fit=make_array(xsize,ysize,/float)
  image_slit_1d=make_array(xsize,/float)

  if chip EQ 0 then begin
     for x=0,xsize-1 do begin
        meanclip_mod,image_slit[x,*],avg,sigma,clipsig=clip_sig
        image_slit_1d[x]=avg
     endfor
     image_slit_1d_test=total(image_slit,2,/NAN)/ysize ; make average spectrum
     lowess_mod,findgen(xsize),image_slit_1d,30,image_slit_1d_fit,order=2 ; fit the spectrum; was 5; 30 is good for NG
     for y=0,ysize-1 do image_slit_2d_fit[*,y]=image_slit_1d_fit ; expand the fit to 2D
  endif else begin
     image_slit_1d=total(image_slit,1,/NAN)/xsize
     lowess_mod,findgen(ysize),image_slit_1d,5,image_slit_1d_fit,order=2
     for i=x,xsize-1 do image_slit_2d_fit[x,*]=image_slit_1d_fit
  endelse
  
  spec_flat=image_slit/image_slit_2d_fit ;normalize the observed with the fit 2D
  nan_range=where(finite(spec_flat,/NAN),count)
  if count GT 0 then spec_flat[nan_range]=1.
 
  image_with_slitflat=image
  image_with_slitflat[x1:x2,y1:y2]=spec_flat ; put flat back to the original
  
;  nan_region=where(image_with_slitflat LT 0.3 OR image_with_slitflat GT 2., count)
;  image_with_slitflat_nan=image_with_slitflat
;  if count GT 0 then image_with_slitflat_nan[nan_region]=!values.f_nan

  plot,image_slit_1d,psym=10
  oplot,image_slit_1d_fit
; oplot,image_slit_1d_test,psym=4

end
