pro map_response

datadir='./RESPONSE/'

response_list_name = DIALOG_PICKFILE (FILTER = '*.lst',title='Input a RESPONSE file list',path=datadir)
irc_listread, response_list, n_response,dir=datadir,list_in=response_list_name
xi=fltarr(n_response)
yi=fltarr(n_response)
lambda=fltarr(100,n_response)
response=fltarr(100,n_response)

for i=0,n_response-1 do begin
    read_response,lambda_tmp,response_tmp,FilenameInput='RESPONSE/'+response_list[i],xi=xi_tmp,yi=yi_tmp
    xi[i]=float(xi_tmp)
    yi[i]=float(yi_tmp)
    lambda[0:n_elements(response_tmp)-1,i]=lambda_tmp
    response[0:n_elements(response_tmp)-1,i]=response_tmp
endfor

ysize=n_elements(response_tmp)

lambda=lambda[0:ysize-1,*]
response=response[0:ysize-1,*]

; Fit response over FOV at every lambda 
coef3d=fltarr(3,ysize)
for i=0,ysize-1 do begin
    coef=robust_planefit(xi,yi,response[i,*],response_fit,response_res)
    coef3d[*,i]=coef
endfor

; calc response at (x, y)
response_xy=fltarr(ysize)
x=0 & y=0
for i=0,ysize-1 do response_xy[i]=coef3d[0,i]+coef3d[1,i]*x+coef3d[2,i]*y

message,'Finish'

end
