pro merge_response

;response1: main
;response2: sub

common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

set_dir & set_color

; for NP longward
;set_response,lambda1,response1,d_response1,response_file=calibdir+'/RESPONSE/20061113/RESPONSE_NP_KF06T2_20061113.dat'
;set_response,lambda2,response2,d_response2,response_file=calibdir+'/RESPONSE/20061113/RESPONSE_NP_KF09T1_20061113.dat'
;replace_lambda1=3.4 & replace_lambda2=6.

; for NG longward
set_response,lambda1,response1,d_response1,response_file=calibdir+'/RESPONSE/20061113/RESPONSE_NG_KF09T1_NP_20061113.dat'
set_response,lambda2,response2,d_response2,response_file=calibdir+'/RESPONSE/20061113/RESPONSE_NG_HD42525_20061113.dat'
replace_lambda1=2.3 & replace_lambda2=4.5

shift_range=6
shift_median=fltarr(shift_range*2+1)
for i=0,shift_range*2 do shift_median[i]=median(lambda1-shift(lambda2,i-shift_range))
min_shift=where(abs(shift_median) EQ min(abs(shift_median)))-shift_range
min_shift=min_shift[0]

plot,lambda1-shift(lambda2,min_shift),yr=[-0.2,0.2]

merged_response=(response1/d_response1+shift(response2/d_response2,min_shift))/ $
                (1./d_response1+1./shift(d_response2,min_shift))
d_merged_response=(d_response1/d_response1+shift(d_response2/d_response2,min_shift))/ $
                  (1./d_response1+1./shift(d_response2,min_shift))/sqrt(2.)

replace_range=where(lambda1 GT replace_lambda1 AND lambda2 LT replace_lambda2,count)
response_out=response1 & d_response_out=d_response1
if count GT 0 then begin
; for NP longward
;  response_out[replace_range]=merged_response[replace_range]
;  d_response_out[replace_range]=d_merged_response[replace_range]
; for NG longward
   response_out[replace_range]=response2[replace_range]
   d_response_out[replace_range]=d_response2[replace_range]
endif

message,'Finish'

plot,lambda1,response1,psym=4,color=red
oplot,lambda1,shift(response2,min_shift),psym=4,color=blue
oplot,lambda1,response_out,psym=10,color=green
oplot,lambda1,response_out,psym=2,color=green


plot,lambda1,d_response1,psym=4,color=red
oplot,lambda1,shift(d_response2,min_shift),psym=4,color=blue
oplot,lambda1,d_response_out,psym=10,color=white
oplot,lambda1,d_response_out,psym=2,color=white

write_response,0,0,lambda1,response_out,d_response_out

end
