PRO psfanalysis

ncolor_plot=6
white  = GetColor('white',  !D.Table_Size-(ncolor_plot-5))
yellow = GetColor('yellow', !D.Table_Size-(ncolor_plot-4))
red    = GetColor('red',    !D.Table_Size-(ncolor_plot-3))
green  = GetColor('green',  !D.Table_Size-(ncolor_plot-2))

;ncol_nir = 412L ; X
;nrow_nir = 512L ; Y
;ncol_mir = 256L ; X
;nrow_mir = 256L ; Y

; file read
;filename = DIALOG_PICKFILE (FILTER = '*.lst',title='Input a file of darks')
irc_fits_read,psf,header

xcut=total(psf,1)
xcut=xcut/max(xcut)

ycut=total(psf,2)
ycut=ycut/max(ycut)

;plot,xcut,titlte='X cut',/ylog

xfit=gaussfit(findgen(512),xcut,coef_x,nterms=3,estimates=[1.,256.,3.])
yfit=gaussfit(findgen(512),ycut,coef_y,nterms=3,estimates=[1.,256.,3.])

window,1
!P.multi=[0,2,2]
!x.range=[256-50,256+50]
plot,xcut,title='Y cut',/ylog
oplot,xfit,color=red,linestyle=0

plot,xcut,title='Y cut'
oplot,xfit,color=red,linestyle=0
print,sqrt(coef_x[2]/2)*2.355/2. ;FWHM in units of real pixel, after corretging for the pixel number

plot,ycut,title='Y cut',/ylog
oplot,yfit,color=red,linestyle=0

plot,ycut,title='Y cut'
oplot,yfit,color=red,linestyle=0

print,sqrt(coef_y[2]/2)*2.355/2. ;FWHM in units of real pixel, after corretging for the pixel number


window,2,xsize=300,ysize=600
!P.multi=[2,1,2]
;!x.range=[0,512] & !y.range=[0,512]
;!x.range=[256-10,256+10] & !y.range=[256-10,256+10]

!x.style=1 & !y.style=1 & !p.charsize=1 & !x.gridstyle=2

!x.range=[-30,30] & !y.range=[-30,30]; in units of arcsec
s=size(psf)
xpix=s[1] & ypix=s[2]
x=fltarr(xpix,ypix) & y=fltarr(xpix,ypix)
pixscale=570./231. & pixscale=pixscale/2.0
for i=0,xpix-1 do x[*,i]=(findgen(xpix)-xpix/2.)*pixscale
for i=0,ypix-1 do y[*,i]=(i-xpix/2.)*pixscale
contour,psf,x,y,levels=[0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],xtitle='arcsec',ytitle='arcsec'

gaussian_psf=gauss2dfit(psf,b)
print,sqrt(b[2]/2)*2.355*pixscale ;FWHM in units of arcsec
print,sqrt(b[3]/2)*2.355*pixscale ;FWHM in units of arcsec
contour,gaussian_psf,x,y,levels=[0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0],/overplot,color=green
contour,psf,x,y,levels=[0.5],/overplot,color=red

residual=psf-gaussian_psf
atv,residual,/block
print,format='(%"Resudual=%f Total=%f Total(Model)=%f ratio=%e")',total(residual),total(psf),total(gaussian_psf),total(residual)/total(psf)
contour,residual,x,y,levels=[-0.1,-0.08,-0.06,-0.04,-0.02,0.,0.02,0.04,0.06,0.08,0.10],color=red


xcut2=total(gaussian_psf,1)
xcut2=xcut2/max(xcut2)


;contour,psf[256-10:256+10,256-10:256+10],levels=[0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0]
message,'Finish'


END
