pro show_trace,specimage3d,source_id,spec_xpos,spec_xpos_fit,weight=weight
COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white

set_color

s=size(specimage3d) & xsize=s[1] & ysize=s[2]

plot_mag=floor(800/ysize)
window,1,xsize=xsize*plot_mag,ysize=ysize*plot_mag,title='Spectrum Peak Fit Result'

if keyword_set(weight) then begin
    window,2,xsize=xsize*plot_mag,ysize=ysize*plot_mag,title='Weight plot'
    OK_range=where(weight[*,source_id] GT 2e-10,count)
endif else begin
    OK_Range=indgen(ysize)
    count=1
endelse
 
wset,1
imdisp,sigrange_irc(specimage3d[*,*,source_id]),margin=0,ncolors=!D.N_COLORS-6
; +0.5 and +1 for range is to account for finite pixel size
yplot=indgen(ysize)

if count GE 1 then begin
    plot,spec_xpos[OK_range,source_id],yplot[OK_range],/device, $
      xrange=[-0.5,xsize-1+0.5],yrange=[-0.5,ysize-1+0.5],xmargin=[0,0],ymargin=[0,0], $
      /noerase,xstyle=1,ystyle=1,psym=4,color=red
    
    oplot,spec_xpos_fit[*,source_id],indgen(ysize),psym=0,color=yellow
endif

if keyword_set(weight) then begin
    wset,2
    !y.range=0. & !x.range=0
    plot,weight[*,source_id],indgen(ysize),/ynozero,xstyle=1,ystyle=1,color=white
endif

end
