pro apply_outlier_saturation_mask,inimage,inimage_short,inimage_mask_sat_fov,inimage_short_mask_sat_fov, $
                                  IMAG=IMAG,fov_mask=fov_mask

  common frame_type,chip,filter,grism
  
  do_outlier_load,outlier_mask
  apply_mask,inimage,      outlier_mask,inimage_mask
  apply_mask,inimage_short,outlier_mask,inimage_short_mask

  if ~ keyword_set(IMAG) then begin
     check_saturation,inimage_mask,      inimage_mask_sat
     check_saturation,inimage_short_mask,inimage_short_mask_sat
  endif else begin
     inimage_mask_sat=inimage_mask
     inimage_short_mask_sat=inimage_short_mask
  endelse

  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B $
     && !IRC_SPECRED_OBSPARAM.Np_mode EQ 0B $
     && !IRC_SPECRED_PROCESSOPTION.no_fov_mask EQ 0B then begin
     do_mask_load,source_table,fov_mask
     if NIR() EQ 0 && keyword_set(IMAG) EQ 0 then begin
        case chip of
           1: begin
              case grism of
                 0: mask_offset=!IRC_SPECRED_SPECEXTRACTPARAM.x_offset
                 1: mask_offset=!IRC_SPECRED_SPECEXTRACTPARAM.x_offset
              endcase
           end
           2: mask_offset=!IRC_SPECRED_SPECEXTRACTPARAM.x_offset
           else: !IRC_SPECRED_SPECEXTRACTPARAM.mask_offset=0
        endcase
        fov_mask2=shift(fov_mask,mask_offset,0,0)
        fov_mask=fov_mask*fov_mask2
     endif
     apply_mask,inimage_mask_sat,      fov_mask,inimage_mask_sat_fov
     apply_mask,inimage_short_mask_sat,fov_mask,inimage_short_mask_sat_fov

  endif else begin              ; no FOV mask
     inimage_mask_sat_fov      =inimage_mask_sat
     inimage_short_mask_sat_fov=inimage_short_mask_sat
  endelse

end
