pro calc_np_distortion,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos, $
                       coef=coef,use_array=use_array,mes_max=mes_max,mes_min=mes_min,error_array=error_array

  COMMON colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
  common GUI,logger

  n_source=n_elements(source_table)
  use_array=intarr(n_source) & peak_fit_pos=fltarr(n_source)

  flux_thresh=!IRC_SPECRED_SPECDETECTPARAM.flux_thresh_for_distortion_measure
  if source_table[0].flux EQ 0 then flux_thresh=0.

  if defined(mes_max) EQ 0 then begin
     mes_max=20 & mes_min=2
  end
  xarray=findgen(mes_max-mes_min+1)

  error_array=fltarr(n_source)

  k=0
  for source_id=0,n_source-1 do begin
     peak_pos=where(specimage_wc_1d[*,source_id] EQ max(specimage_wc_1d[*,source_id]),count)
     peak_pos_ok= $
        peak_pos[0] LT mes_max && peak_pos[0] GT mes_min && count EQ 1 $
        && source_table[source_id].image_y LT 412+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset-30 $
        && source_table[source_id].image_y GT (!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2-!IRC_SPECRED_SPECEXTRACTPARAM.y_offset
     if peak_pos_ok then begin
        if !IRC_SPECRED_MISC.DEBUG then begin
           plot,xarray,specimage_wc_1d[mes_min:mes_max,source_id],color=white,/ynozero,psym=10
        endif
        result=mpfitpeak_nan(xarray,specimage_wc_1d[mes_min:mes_max,source_id],A,nterms=5,sigma=sigma,/positive)
        result=mpfitpeak_nan(xarray,specimage_wc_1d[mes_min:mes_max,source_id]>(A[0]*2./3.),AA,nterms=4,sigma=sigma,/positive, $
                             dof=dof,perror=perror,bestnorm=bestnorm)
        if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,0,0]
        if error[1] LT 0.2 && AA[2] LT 2. && AA[2] GT 0.3 && $
           source_table[source_id].flux GE flux_thresh && source_table[source_id].bad_sourcepos_flag EQ 0B then begin
           peak_fit_pos[source_id]=AA[1]
           error_array[source_id]=error[1]
           
           if !IRC_SPECRED_MISC.DEBUG then begin
              oplot,xarray,result,color=red & wait,1.
           endif
           use_array[k]=source_id
           k+=1
        endif
     endif                      ; of peak_pos_ok
  endfor                        ; of source_id loop
  
  if k GT 0 then begin
     use_array=use_array[0:k-1]
     error_array=error_array[0:k-1]
  endif else begin
     print,'Warning (calc_np_distortion): No data are available for measurement... Returning 0!'
     peak_fit_pos=0. & peak_mean_pos=0.
     return
  endelse
  
  peak_fit_pos=peak_fit_pos[use_array]
  
; average peak_fit_pos array to find peak_mean_pos
; robomean,peak_fit_pos,3.0,0.5,peak_mean_pos,avgdev,stddev_value,var,skew,kurt,nfinal,new
  meanclip_mod,peak_fit_pos,peak_mean_pos,sigma,clipsig=3.0
  peak_fit_sigma=robust_sigma_mod(peak_fit_pos)
  if peak_fit_sigma GT 1. then $
     print,'Warning (calc_np_disttortion): error of specbox Y shift seems too large! '+strim(peak_fit_sigma)+ ' (pix)'
  
  if n_elements(use_array) GT 7 then $
     coef=rob_quarticfit(source_table[use_array].spec_x,source_table[use_array].spec_y,peak_fit_pos-peak_mean_pos,fit,sig)
  
; This is an outlier-resistant fit to Z = a + bX + cX^2 + dY +eY^2 + fX*Y.
  
;plot,source_table[use_array].image_y,peak_fit_pos-peak_mean_pos-fit,psym=4,color=white;,yrange=[-0.5,0.5]
;print,sig
  
end
