pro do_image_combine,refimage_ff,refimage_ff_short,refimage_ff_out_shift,specimage_ff,specimage_ff_short,specimage_ff_out_shift, $
                     weight_spec=weight_spec,weight_ref=weight_ref,noisemap=noisemap

; Combine all indiv frames
  
  common gui,logger
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  
  logger->append,['---','Image combining...']

  s=size(specimage_ff) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1

  if !IRC_SPECRED_OBSPARAM.slit_mode || !IRC_SPECRED_OBSPARAM.preflight_mode then begin
     irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out_shift,/NO_SHIFT 
     irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out_shift,/NO_SHIFT
     return
  endif

   case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        logger->append,['Refimage median averaging.']
        if !IRC_SPECRED_OBSPARAM.AOT NE '02B' then $
           irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                           comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE, $
                           /IMAG,/no_shift $ ;,/sky_adj $
        else $
           irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                           comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE, $
                           /IMAG ;,sky_adj ; for 02B there are more than 2 frames to be combined.
        
        if !IRC_SPECRED_PROCESSOPTION.shift_from_file EQ 1B then begin
           print,'Information (do_image_combine): NIR subframe offsets will be read from the database'
           if NP() then read_image_shift_info,id,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat' $
           else         read_image_shift_info,id,dx,dy,filename=workdir+'/NG_SHIFT_XY.dat'
        endif

        if !IRC_SPECRED_OBSPARAM.AOT NE '02B' then begin
           logger->append,['Specimage sigma clipping averaging.']
           irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                           dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE, $
                           clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec

           noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
           noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)

           irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                           dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE, $
                           clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec,noisemap_in=noisemap_med
 
;          meanclip_mod,noisemap[*,*,1],avg,sigma,clip=3.
        endif else begin
           logger->append,['Specimage median averaging.']
           irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                           dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE,weight=weight_spec
        endelse

        if !IRC_SPECRED_PROCESSOPTION.shift_from_file NE 1B then begin
           print,'Information (do_image_combine): NIR subframe offsets were written in the database.'
           if NP() then write_image_shift_info,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat' $
           else         write_image_shift_info,dx,dy,filename=workdir+'/NG_SHIFT_XY.dat'
        endif
     end

     1: begin
        logger->append,['Refimage median combining.']
        irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out,$;/sky_adj, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE,/IMAG
        write_image_shift_info,dx,dy,filename=workdir+'/S9W_SHIFT_XY.dat'

        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              case 1 of
                 (!IRC_SPECRED_OBSPARAM.AOT NE '04B'): begin
                    print,'Information (do_image_combine): This is AOT04A/C follow-NIR mode, using NP shift data.'
                    read_image_shift_info,id,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat'
                 end
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04B'): begin
                    print,'Information (do_image_combine): This is AOT04B follow-NIR mode, using NG shift data.'
                    read_image_shift_info,id,dx,dy,filename=workdir+'/NG_SHIFT_XY.dat'
                 end
              endcase
              logger->append,['Specimage sigma clipping averaging.']
              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec

              noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
              noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)
;              noisemap_med=filter_image_nan(noisemap[*,*,1],median=1,/all)
              
              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec,noisemap_in=noisemap_med

           end
           1: begin
              case 1 of
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04A'): begin
                    print,'Information (do_image_combine): This is AOT04A follow-NIR mode, using NP shift data.'
                    read_image_shift_info,id,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat'
                 end
                 (!IRC_SPECRED_OBSPARAM.AOT EQ '04B' || !IRC_SPECRED_OBSPARAM.AOT EQ '04C'): begin
                    print,'Information (do_image_combine): This is AOT04B/C follow-NIR mode, using NG shift data.'
                    read_image_shift_info,id,dx,dy,filename=workdir+'/NG_SHIFT_XY.dat'
                 end
              endcase
              logger->append,['Specimage sigma clipping averaging.']
              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec

;              noisemap_med=filter_image_nan(noisemap[*,*,1],median=1,/all)
              noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
              noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)

              irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                              dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                              clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec,noisemap_in=noisemap_med


           end
        endcase
     end

     2: begin
        logger->append,['Refimage median combining.']
        print,'Information (do_image_combine): This is follow-MIRS refimage stacking mode, using S9W shift data.'
        read_image_shift_info,id,dx,dy,filename=workdir+'/S9W_SHIFT_XY.dat'
        irc_imcombine_n,refimage_ff,refimage_ff_short,refimage_ff_out, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.IMAG_COMBINE_MODE,/IMAG,/follow_NIR;,/sky_adj
        case 1 of
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04C'): begin
              print,'Information (do_image_combine): This is AOT04C follow-NIR mode, using both NP and NG shift data.'
              read_image_shift_info,id,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat'
              read_image_shift_info,id,dx2,dy2,filename=workdir+'/NG_SHIFT_XY.dat'
              read_specbox_shift_x,shift_x_np,filename=workdir+'/NP_SPECBOX_SHIFT_X.dat'
              read_specbox_shift_x,shift_x_ng,filename=workdir+'/NG_SPECBOX_SHIFT_X.dat'
;             print,shift_x_np,shift_x_ng
              dx2+=shift_x_ng-shift_x_np ; temp setting
              read_specbox_shift_y,shift_y_ng,filename=workdir+'/NG_SPECBOX_SHIFT_Y.dat'
              read_specbox_shift_y,shift_y_np,filename=workdir+'/NP_SPECBOX_SHIFT_Y.dat'
              dy2+=shift_y_ng-shift_y_np
              dx=[dx,dx2] & dy=[dy,dy2]
           end
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04A'): begin
              print,'Information (do_image_combine): This is AOT04A follow-NIR mode, using NP shift data.'
              read_image_shift_info,id,dx,dy,filename=workdir+'/NP_SHIFT_XY.dat'
           end
           (!IRC_SPECRED_OBSPARAM.AOT EQ '04B'): begin
              print,'Information (do_image_combine): This is AOT04B follow-NIR mode, using NG shift data.'
              read_image_shift_info,id,dx,dy,filename=workdir+'/NG_SHIFT_XY.dat'
           end
        endcase

        logger->append,['Specimage sigma clipping averaging.']
        irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                        clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec
 
        noisemap_med=sigma_filter(noisemap[*,*,1],radius=1,/all,/iterate,n_sigma=2.)
;       noisemap_med=filter_image_nan(noisemap[*,*,1],median=3,/all)
        noisemap_med=loess_mod(noisemap_med,3,1,floor=-100.)

        irc_imcombine_n,specimage_ff,specimage_ff_short,specimage_ff_out,rmsimage=noisemap, $
                        dx=dx,dy=dy,comb_mode=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_MODE,/follow_NIR, $
                        clip_sig=!IRC_SPECRED_COMBINEPARAM.SPEC_COMBINE_SIGMA,weight=weight_spec,noisemap_in=noisemap_med

        specimage_ff_out=sigma_filter_cube(specimage_ff_out,1,n_sigma=5.)
        refimage_ff_out=sigma_filter_cube(refimage_ff_out,1,n_sigma=5.)
     end
  endcase

   meanclip_mod,noisemap[*,*,1],avg,sigma,clip=3.
   print,'Information (do_image_combine): typical pixel count variation (RMS) in ADU = '+strim(avg/sqrt(n_frame))

; align short and long image
   logger->append,['Adjusting short-long exposure frame shift.']
   irc_align_short_long,refimage_ff_out,refimage_ff_out_shift
   irc_align_short_long,specimage_ff_out,specimage_ff_out_shift,/spec

end
