pro do_load_images,ext_source_table,refimage_file,specimage_file,darkimage_file, $
                   refimage_wrapcor,refimage_wrapcor_short,specimage_wrapcor,specimage_wrapcor_short, $
                   imageheader,specheader, $
                   superdark,imageflat,specflat,flatcor,refdark

  common gui,logger
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

  logger->append,['Pipeline job for '+strim(!IRC_SPECRED_PROCESSTARGET.targetid)+' '+$
                                              strim(!IRC_SPECRED_PROCESSTARGET.targetsubid)+' '+ $
                  ': '+!IRC_SPECRED_PROCESSTARGET.filter_spec+ $
                  '; AOT:'+!IRC_SPECRED_OBSPARAM.AOT]

  logger->append,['---','Loading data...']


  if !IRC_SPECRED_OBSPARAM.preflight_mode then begin
     irc_list_fits_read, refimage_file, refimage_nir, refimage_mirs, refimage_mirl, $
                         n_nir,n_mir, imageheader_nir,imageheader_mirs,imageheader_mirl,dir=datadir2,/separate
     irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                        n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl,dir=datadir2,/separate
  endif else begin
     check_input_files,ext_source_table,refimage_file,specimage_file,darkimage_file

     irc_list_read,darkimage_list,n_dark,list_in=darkimage_file
     irc_list_read,refimage_list,n_refimage,list_in=refimage_file
     irc_list_read,specimage_list,n_specimage,list_in=specimage_file

     case n_dark of
        3: begin
                                ; remove partial dark (dark that is taken during maneuver)
           darkimage_list_tmp=darkimage_list[0:n_dark-2]
           darkimage_list_tmp[n_dark-2]=darkimage_list[n_dark-1]
           darkimage_list=darkimage_list_tmp
           print,'Warning (do_load_images): remove a set of partial dark!'
        end
        2: begin
           if $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04A' && (NP() || SG2() || LG2())) || $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04B' && (NG() || SG2() || LG2())) || $
              (!IRC_SPECRED_OBSPARAM.AOT EQ '04C' && (NG() || SG2() || LG2())) then begin
              if !IRC_SPECRED_PROCESSOPTION.use_all_images_mode EQ 0 then begin
                 n_specimage=n_elements(specimage_list)
                 specimage_list=specimage_list[0:n_specimage-2]
                 print,'Warning (do_load_images): removed the last spec image from a list since it is taken during maneuver!'
              endif else begin
                 print,'Warning (do_load_images): the last spec image was taken during maneuver, but is not removed!'
              endelse
           endif
        end
        else: begin
           print,'Warning (do_load_images): something is wrong in the dark list!'
        end
     endcase
     
     irc_list_fits_read, refimage_file, refimage_nir, refimage_mirs, refimage_mirl, $
                         n_nir,n_mir, imageheader_nir,imageheader_mirs,imageheader_mirl,dir=datadir2,imagelist=refimage_list
     irc_list_fits_read,specimage_file,specimage_nir,specimage_mirs,specimage_mirl, $
                        n_nir,n_mir, specheader_nir,specheader_mirs,specheader_mirl,dir=datadir2,imagelist=specimage_list
     irc_list_fits_read,darkimage_file,darkimage_nir,darkimage_mirs,darkimage_mirl, $
                        n_nir,n_mir, darkheader_nir,darkheader_mirs,darkheader_mirl,dir=datadir2,imagelist=darkimage_list
  endelse

; following procedures return dark/flat array of specified type
  set_superdark,        superdark,darkheader
  set_superflat,'image',imageflat,imageheader
  set_superflat,'spec', specflat ,specflatheader
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin                   ; NIR
        specimage_n=specimage_nir  & refimage_n =refimage_nir
        specheader =specheader_nir & imageheader=imageheader_nir
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_nir
           darkheader=darkheader_nir
        endif
        
        imrot_NIR,refimage_n,specimage_n,imageflat,specflat,superdark,refdark
                                ; rotate 90deg counter-clockwise to
                                ; match slit dir.
     end
     1: begin                   ; MIRS
        specimage_n=specimage_mirs  & refimage_n =refimage_mirs
        specheader =specheader_mirs & imageheader=imageheader_mirs
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_mirs
           darkheader=darkheader_mirs
        endif
        
     end
     2: begin                   ; MIRL
        specimage_n=specimage_mirl  & refimage_n =refimage_mirl
        specheader =specheader_mirl & imageheader=imageheader_mirl
        if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
           refdark=darkimage_mirl
           darkheader=darkheader_mirl
        endif
     end
  endcase
  
  reform_irc_cube,specimage_n,specimage,specimage_short
  reform_irc_cube, refimage_n,refimage, refimage_short
  
; Warp correction
  if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B then begin
     wrapcor,specimage,specimage_wrapcor
     wrapcor,specimage_short,specimage_wrapcor_short,/short
     if MIRL() then refimage_wrapcor=refimage else wrapcor,refimage,refimage_wrapcor
     wrapcor,refimage_short,refimage_wrapcor_short,/short

  endif else begin
     specimage_wrapcor=specimage
     specimage_wrapcor_short=specimage_short
     refimage_wrapcor=refimage
     refimage_wrapcor_short=refimage_short
  endelse
  
end
