pro do_param_initialize,filter_spec,targetid,targetsubid, $
                        root_dir=root_dir,no_logger_init=no_logger_init, $
                        refimage_list=refimage_list, $
                        reference_fits=reference_fits, $
                        file_in_workdir=file_in_workdir, $
                        no_database_check=no_database_check

  common frame_type,chip,filter,grism
  common gui,logger
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

  !quiet=1                      ; no compile message
  !except=0                     ; disable error reporting
  set_color,/white_bg
  if keyword_set(no_logger_init) EQ 0 then logger_init,logger
  set_dir,targetid,targetsubid,root_dir=root_dir
  
  if keyword_set(file_in_workdir) then datadir2=workdir
  
; FILTER Spec
  if defined(filter_spec) EQ 0 then FILTER_SPEC=dialog_menu(['N3_NP','N3_NG','S9W_SG1','S9W_SG2','L18W_LG2','OTHER'])
  decode_filter_spec,filter_spec,chip,grism
  
  !IRC_SPECRED_PROCESSTARGET.chip=chip
  !IRC_SPECRED_PROCESSTARGET.grism=grism
  !IRC_SPECRED_PROCESSTARGET.filter_spec=filter_spec

  if defined(targetid) then !IRC_SPECRED_PROCESSTARGET.targetid=targetid
  if defined(targetsubid) then !IRC_SPECRED_PROCESSTARGET.targetsubid=targetsubid

  set_specextractparam,chip,grism
  if !IRC_SPECRED_OBSPARAM.Np_mode then !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx+=15; widen the width to cover entire Np area
  set_chipinfo,chip,grism
  set_specinfo,chip,grism
  set_areainfo,chip,grism
  
; check required list files before starting the processes
  if defined(refimage_list) || defined(reference_fits) then begin
     if defined(refimage_list) then begin
        check_file,datadir2+'/'+refimage_list
        READCOL,datadir2+'/'+refimage_list, FORMAT='A', imagename,/silent
        imagename=datadir2+'/'+imagename
     endif else begin
        if defined(reference_fits) then begin
           check_file,datadir2+'/'+reference_fits
           imagename=datadir2+'/'+reference_fits
        endif
     endelse
     
; find AOT info
     get_aot_info_irc,imagename[0]
     
  endif
  
  set_operation_mode,chip,grism
  set_process_params,chip,grism

  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0 && !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B $
     && keyword_set(no_database_check) EQ 0B then check_database ; check database files
  
end
