pro do_skysub_n,source_table,specimage_n,mask_specimage_n,specimage_n_bg, $
                fov_mask=fov_mask,mmm=mmm,mask_specimage_n_remove_all_source=mask_specimage_n_remove_all_source, $
                noisemap_n=noisemap_n,noise_mask=noise_mask

; do residual sky subtraction for each extracted specimage
  common gui,logger

  if ~ defined(mask_specimage_n) then make_mask_n,source_table,mask_specimage_n,fov_mask=fov_mask,noise_mask=noise_mask
  if ~ defined(mask_specimage_n_remove_all_source) then $
     make_mask_n,source_table,mask_specimage_n_remove_all_source,/remove_all_source,fov_mask=fov_mask,noise_mask=noise_mask

  if defined(noisemap_n) then weightmap_n=1./noisemap_n^2.

  if !IRC_SPECRED_OBSPARAM.Ns_mode || !IRC_SPECRED_OBSPARAM.Nh_mode || !IRC_SPECRED_OBSPARAM.Ls_mode then begin
     specimage_n_bg=specimage_n
     sigma_ADU=fltarr(n_elements(source_table)) ; zero!
  endif else begin
     logger->append,[['---','Sky-subtracting (local) from all extracted spectra...']]
     if NP() || keyword_set(mmm) then $
        irc_skysub_n,source_table,specimage_n,mask_specimage_n_remove_all_source,specimage_n_bg,sigma_ADU, $
                     weightmap3d=weightmap_n,noisemap3d=noisemap_n,/mmm $
     else $
        irc_skysub_n,source_table,specimage_n,mask_specimage_n_remove_all_source,specimage_n_bg,sigma_ADU, $
                     weightmap3d=weightmap_n,noisemap3d=noisemap_n
  endelse
  
; if source_table[0].spec_bgnoise_ADU EQ 0. then $ ; if not previously set...
  source_table.spec_bgnoise_ADU=sigma_ADU
  print,'Information (do_skysub_n): typical skynoise (RMS in ADU) = '+strim(sigma_ADU[0])

end
