pro do_tune_sourcepos,image,source_table,x,y,x_new,y_new, $
                      flux=flux,FWHM=FWHM,median=median,use_array=use_array,no_photo=no_photo,for_skysub_only=for_skysub_only
     
; input (x, y) -> output (x1, y1)
  tune_sourcepos,image,x,y,x1,y1,x_error0,y_error0, $
                 median=median,flux=flux,FWHM=FWHM,use_array=use_array,no_photo=no_photo, $
                 mean_dx=mean_dx,mean_dy=mean_dy,/silent

; input (x1, y1) -> output (x2, y2)
  if use_array[0] NE -1 then begin
;    dx=median(x1[use_array]-x[use_array])
;    dy=median(y1[use_array]-y[use_array])
     dx=mean_dx[0]
     dy=mean_dy[0]
     x2=x+dx & y2=y+dy
     if abs(dx) GT 0.5 || abs(dy) GT 0.5 then $
        print,'Information (do_tune_sourcepos): source pos. offsets are '+strim(dx)+','+strim(dy)
  endif else begin
     x2=x & y2=y
  endelse

  if !IRC_SPECRED_PROCESSOPTION.ext_source_table_mode EQ 1B then begin ; fit again for better source pos tuning

; input (x2, y2) -> output (x3, y3)
     tune_sourcepos,image,x2,y2,x3,y3,x_error,y_error, $
                    median=median,flux=flux,FWHM=FWHM,use_array=use_array,no_photo=no_photo, $
                    mean_dx=mean_dx,mean_dy=mean_dy,/silent
     
; input (x3, y3) -> output (x_new, y_new)
     if use_array[0] NE -1 then begin
;       dx=median(x3[use_array]-x2[use_array])
;       dy=median(y3[use_array]-y2[use_array])
        dx=mean_dx[0]
        dy=mean_dy[0]
        x_new=x2+dx & y_new=y2+dy
        if abs(dx) GT 0.5 || abs(dy) GT 0.5 then $
           print,'Information (do_tune_sourcepos): source pos. offsets are '+strim(dx)+','+strim(dy)
     endif else begin
        print,'Warning (do_tune_sourcepos): shift values could not be measured!'
        x_new=x2 & y_new=y2
     endelse
  endif else begin
     x_new=x2 & y_new=y2
  endelse

  if use_array[0] NE -1 then begin
     n_source=n_elements(x_new)
     make_default_source_table,source_table,n_source
     source_table.image_x=x_new & source_table.image_y=y_new
     source_table.flux=flux & source_table.image_FWHM=FWHM
     
     if defined(source_table) then begin
        for source_id=0,n_source-1 do begin
           result=where(use_array EQ source_id,count)
           if count EQ 0 then source_table[source_id].bad_sourcepos_flag=1B
        endfor
     endif
  endif

end
