pro set_plot_pos,off1,off2,cen_off

  common measured_offsets,space_shift,nsum
  
  if NP() || SG1() || SG2() then begin
     if (nsum mod 2) EQ 1 then begin
        off1=(nsum-1.)/2.+0.5
        off2=(nsum-1.)/2.+0.5
        cen_off=0.
     endif else begin
        off1=nsum/2.+0.5
        off2=nsum/2.+0.5-1.0
        cen_off=0.5
     endelse
  endif else begin
     if (nsum mod 2) EQ 1 then begin
        off1=(nsum-1.)/2.+0.5
        off2=(nsum-1.)/2.+0.5
        cen_off=0.
     endif else begin
        off1=nsum/2.+0.5
        off2=nsum/2.+0.5-1.0
        cen_off=-0.5
     endelse
  endelse

end

pro draw_tv,specimage_n_wc,specmask_n,wave_array_shift,source_id, $
            smooth_width=smooth_width,sigma_filter_set=sigma_filter_set, $
            tvtop=tvtop,tvbottom=tvbottom,margin=margin,x_winsize=x_winsize,y_winsize=y_winsize,ps=ps, $
            bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset

  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
  common measured_offsets,space_shift,nsum
     
  if keyword_set(sigma_filter_set) then $
     specimage_n_wc_tmp=sigma_filter(specimage_n_wc[*,*,source_id]*specmask_n[*,*,source_id],radius=1,/all,/iterate) $
  else $
     specimage_n_wc_tmp=specimage_n_wc[*,*,source_id]*specmask_n[*,*,source_id]
  
  if ~ defined(smooth_width) then begin
     smooth_width=1
     rotated_image=rotate(specimage_n_wc_tmp,3)
  endif else begin
     rotated_image=rotate(smooth(specimage_n_wc_tmp,[nsum,smooth_width],/NAN),3)
  endelse

  if ~ defined(PS) then begin
     tv,congrid( $
        bytscl(rotated_image,max=tvtop,min=tvbottom) $
        ,x_winsize*(1.0-margin*2.),y_winsize/2.*(1.0-margin*2.) $
               ) $
        ,x_winsize*margin,y_winsize/2.*margin
  endif else begin
     tv,congrid( $
        bytscl(rotated_image,max=tvtop,min=tvbottom) $
        ,x_winsize*(1.0-margin*2.),y_winsize/2.*(1.0-margin*2.) $
               ) $
        ,29.7*margin,21.0/2.*margin,$
;        xsize=10,ysize=10, $
        /centimeters,$
        xsize=29.7*(1.0-margin*2),ysize=21.0*(1.0-margin*2.)/2.
  endelse
  
  !p.position=[margin,0.5*margin,1.0-margin,0.5*(1.0-margin)]
  
  if NP() || SG1() || SG2() then $
     !Y.range=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
               -(!irc_specred_specextractparam.specaper_dx-1)/2] $
  else $
     !Y.range=[+(!irc_specred_specextractparam.specaper_dx-1)/2, $
               -(!irc_specred_specextractparam.specaper_dx-1)/2]

  set_plot_pos,off1,off2,cen_off
  
  plot,[0,x_winsize],[space_shift+cen_off,space_shift+cen_off], $
       color=blue,/noerase,ytitle='space offset (pix)',xtickinterval=x_winsize*2,xminor=1 ; no minor ticks

  if NP() then begin
     x1=20./!irc_specred_specextractparam.specaper_dy*x_winsize
     x2=x_winsize
  endif else begin
     x1=0.
     x2=x_winsize
  endelse

  oplot,[x1,x2],[float(space_shift)+off1,float(space_shift)+off1],color=red
  oplot,[x1,x2],[float(space_shift)-off2,float(space_shift)-off2],color=red
 
  if NP() then begin            ; widen the width for otamajakusi no atama
     nsum=nsum+6
     set_plot_pos,off1,off2,cen_off
     nsum=nsum-6
     oplot,[0.,20./!irc_specred_specextractparam.specaper_dy*x_winsize],[float(space_shift)+off1,float(space_shift)+off1],color=red
     oplot,[0.,20./!irc_specred_specextractparam.specaper_dy*x_winsize],[float(space_shift)-off2,float(space_shift)-off2],color=red
  endif
  
  if NG() then tick_interval=25. else tick_interval=10.

  if NP() then begin
     axis,xaxis=0,xrange=[0,!irc_specred_specextractparam.specaper_dy], $
          color=red,xtitle='Pixel',xtickinterval=10
     xtick_location=indgen(fix(!irc_specred_specextractparam.specaper_dy/tick_interval)+1)*tick_interval
     xtick_name=wave_array_shift(xtick_location)
     axis,xaxis=1,xrange=[0,!irc_specred_specextractparam.specaper_dy],color=red, $
          xtickinterval=tick_interval,xtickv=xtick_location,xtickname=xtick_name
  endif else begin
     tick_pos=[2.,3.,4.,5.,6.,7.,8.,9.,10.,11.,12.,13.,14.,15.,16.,17.,18.,19.,20.,21.,22.,23.,24.,25.,26.]
     n_tics=n_elements(tick_pos)
     axis,xaxis=1,xrange=[wave_array_shift[0],wave_array_shift[!irc_specred_specextractparam.specaper_dy-1]],color=red, $
          xticks=n_tics,xtickv=tick_pos,xtitle='Wavelength (um)'
  endelse

  !X.range=0 & !Y.range=0
  
end
