function dark_scale,superdark,refdark,short=short

; scale dark image according to inimage count.

  common gui,logger
  
  s=size(refdark) & if s[0] EQ 3 then n_subframe=s[3] else n_subframe=1
  scaled_dark=fltarr(size(refdark,/dimensions))
  
  logger->append,['  Dark offset (ADU):']
  
  if keyword_set(short) then begin
; for short
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask_x1: !IRC_SPECRED_AREAINFO.slitmask_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask_y1: !IRC_SPECRED_AREAINFO.slitmask_y2,0], $
             dark_mean ,sigma,skew
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,0], $
             dark_mean2,sigma,skew
     irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask_x1:!IRC_SPECRED_AREAINFO.slitmask_x2, $
                     !IRC_SPECRED_AREAINFO.slitmask_y1:!IRC_SPECRED_AREAINFO.slitmask_y2, 0],$
             refdark_dark_mean ,sigma,skew
     irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                     !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,0], $
             refdark_dark_mean2,sigma,skew
     dark_offset=((refdark_dark_mean-dark_mean)+(refdark_dark_mean2-dark_mean2))/2.
     dark_mean_mean=(refdark_dark_mean+refdark_dark_mean2)/2.
     d_dark_frac=dark_offset/dark_mean_mean*100.
     logger->append,['    Subframe id'+string(0)+': '+string(dark_offset)]
     scaled_dark[*,*,0]=superdark[*,*,0]+dark_offset
  endif else begin
; for long
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask_x1: !IRC_SPECRED_AREAINFO.slitmask_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask_y1: !IRC_SPECRED_AREAINFO.slitmask_y2,1],$
             dark_mean ,sigma,skew
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,1], $
             dark_mean2,sigma,skew
     
     for i=1,n_subframe-1 do begin
        irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask_x1:!IRC_SPECRED_AREAINFO.slitmask_x2, $
                        !IRC_SPECRED_AREAINFO.slitmask_y1:!IRC_SPECRED_AREAINFO.slitmask_y2, i], $
                refdark_dark_mean ,sigma,skew
        irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                        !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,i], $
                refdark_dark_mean2,sigma,skew
        
        dark_offset=((refdark_dark_mean-dark_mean)+(refdark_dark_mean2-dark_mean2))/2.
        dark_mean_mean=(refdark_dark_mean+refdark_dark_mean2)/2.
        d_dark_frac=dark_offset/dark_mean_mean*100.
;  print,(dark_mean+dark_mean2)/2.,(refdark_dark_mean+refdark_dark_mean2)/2.
        logger->append,['    Subframe id'+string(i)+': '+string(dark_offset)]
;  print,'dark offset '+string(dark_offset)
        scaled_dark[*,*,i]=superdark[*,*,i]+dark_offset
     endfor
  endelse
  
  return,scaled_dark
  
end

PRO irc_darksub,inimage,superdark,refdark,outimage, $
                scale=scale,short=short

  s=size(inimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  outimage=fltarr(size(inimage,/dimensions))

  if keyword_set(scale) then scaled_dark=dark_scale(superdark,refdark[*,*,*,0],short=short) else $
                             scaled_dark=superdark
                                ; refdark[*,*,*,0] means pre-dark.
  if keyword_set(short) then begin
     for frame_id=0,n_frame-1 do outimage[*,*,frame_id]=inimage[*,*,frame_id]-scaled_dark[*,*,0]
  endif else begin              ; for long
     for frame_id=0,n_frame-1 do begin
        outimage[*,*,frame_id]=inimage[*,*,frame_id]-scaled_dark[*,*,1]
; do self dark sub
        if NIR() || MIRS() then begin
           irc_mmm,outimage[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                            !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2, frame_id], $
                   self_dark_mean,sigma,skew
; upper-left most sub-region
           outimage[*,*,frame_id]-=self_dark_mean
        endif
     endfor
  endelse
  
END
