pro irc_distcalib,image,dx_obs,dy_obs,outimage
;
; do distcalib in both wave and space directions
; transform an original image (x_obs, y_obs) to (x, y)
;           with dx_obs->dx and dy_obs->dy
; e.g.; dx_obs: original (observed) x offset; dx: corrected x offset
;
; specimage(x,y,sub_frame_id,exp_cycle)

; outimage(j,i)

; id of each corner of pseudo pixel
;1 2
;3 4

  fluxconserveflag = 1

;;;
;;; main program
;;;
  outimage=image
  s=size(image)
  ncol=s[1] & nrow=s[2]

  for i=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1-1 do begin
     
     xarray=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)+0.5
     yarray=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx) & yarray[*]=float(i)+0.5
     
     TransX=(xarray+dx_obs[i  ]) < (ncol-1) > 0
     NextY_TransX=(xarray+dx_obs[i+1]) < (ncol-1) > 0
     
     TransY=(yarray   +dy_obs[i  ]) < (nrow-1) > 0
     NextY_TransY=(yarray+1.+dy_obs[i+1]) < (nrow-1) > 0
     
     R_TransX=Round(TransX) & R_TransY=Round(TransY)
     F_TransX=Floor(TransX) & F_TransY=Floor(TransY)
     
     R_NextY_TransX=round(NextY_TransX) & R_NextY_TransY=round(NextY_TransY)
     F_NextY_TransX=FLOOR(NextY_TransX) & F_NextY_TransY=FLOOR(NextY_TransY)
     
     dj2=NextY_TransX-R_NextY_TransX
     di2=NextY_TransY-R_NextY_TransY
     dj4=TransX-R_TransX
     di4=TransY-R_TransY
     
     dj1=shift(dj2,1) & di1=shift(di2,1) & dj3=shift(dj4,1) & di3=shift(di4,1)
     
;    fac1a= (0.5-dj1)*(0.5-di1)
;    fac2a= (0.5+dj2)*(0.5-di2)
;    fac3a= (0.5-dj3)*(0.5+di3)
;    fac4a= (0.5+dj4)*(0.5+di4)
     
     fac1a= (0.5-dj1)*(0.5+di1)
     fac2a= (0.5+dj2)*(0.5+di2)
     fac3a= (0.5-dj3)*(0.5-di3)
     fac4a= (0.5+dj4)*(0.5-di4)
     
    
     jj2a=R_NextY_TransX & ii2a=R_NextY_TransY-1 ; -1 is new on 20061103
     jj4a=R_TransX & ii4a=R_TransY-1 ; -1 is new on 20061103
     jj1a=shift(jj2a,1) & ii1a=shift(ii2a,1)
     jj3a=shift(jj4a,1) & ii3a=shift(ii4a,1)

;    print,i,fac1a[4],fac2a[4],fac3a[4],fac4a[4],jj3a[4],ii3a[4]
     
     outimage[*,i]= $
        (image[jj1a,ii1a]*fac1a) $
        +(image[jj2a,ii2a]*fac2a) $
        +(image[jj3a,ii3a]*fac3a) $
        +(image[jj4a,ii4a]*fac4a) 
     
     outimagearea=    fac1a+fac2a+fac3a+fac4a
     
     for j=1,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-2 do begin ; first (0) and last (specaper_dx-1) is not good for calc.
        
        jj1=R_NextY_TransX[j-1] & ii1=R_NextY_TransY[j-1] ; was j-1 in all four entries
        jj3=R_TransX[j-1] & ii3=R_TransY[j-1]
        
        jj2=R_NextY_TransX[j] & ii2=R_NextY_TransY[j]
        jj4=R_TransX[j] & ii4=R_TransY[j]
        
        IF (~ ( (jj2 EQ (jj1+1)) && (ii2 EQ ii1) && (jj3 EQ jj1) && $
;                  (ii3 EQ (ii1+1)) AND (jj4 EQ (jj1 +1)) AND (ii4 EQ (ii1 +1)) ) $
                  (ii1 EQ (ii3+1)) && (jj4 EQ (jj1 +1)) && (ii1 EQ (ii4 +1)) ) $
           ) then begin

           flag=0 & flagx=0
           
           IF ((jj2 - jj1) GT 1) then begin ; x 1 pixel jump
              IF (ii2 EQ ii1) then begin ; y same line
                 outimage[j,i]=outimage[j,i]+image[jj2-1,ii1] * (0.5-di1[j])
                 outimagearea[j]=outimagearea[j]+(0.5-di1[j])
                 goto,jump1
              endif
              
              IF (ii2 EQ (ii1 -1)) then begin
                 outimage[j,i]=outimage[j,i]+image[jj2-1,ii1]
                 outimagearea[j]=outimagearea[j]+1.0
                 goto,jump1
              endif
              
              IF (ii2 EQ (ii1 +1)) then begin
                 outimage[j,i]=outimage[j,i]+image[jj2-1,ii1+1]
                 outimagearea[j]=outimagearea[j]+1.0
                 flagx=1
              endif
           endif
jump1:
           
           IF ((ii1 - ii3) GT 1) then begin ; y 1 pixel jump; was 3-1
              IF (jj3 EQ jj1) then begin
                 outimage[j,i]=outimage[j,i]+image[jj1,ii3-1] * (0.5-dj1[j])
                 outimagearea[j]=outimagearea[j]+(0.5-dj1[j])
                 goto,jump2
              endif
              IF (jj3 EQ (jj1 -1)) then begin
                 outimage[j,i]=outimage[j,i]+image[jj1,ii3-1]
                 outimagearea[j]=outimagearea[j]+1.0
                 goto,jump2
              endif
              IF (jj3 EQ (jj1+1)) AND (flagx EQ 0) then begin
                 outimage[j,i]=outimage[j,i]+image[jj1+1,ii3-1]
                 outimagearea[j]=outimagearea[j]+1.0
                 flag=1
              endif
           ENDIF
jump2:
           
           IF ((jj4 - jj3) GT 1) then begin ; x 1 pixel jump sono 2
              IF (ii3 EQ ii4) then begin
                 outimage[j,i]=outimage[j,i]+image[jj4-1,ii3] * (0.5+di3[j])
                 outimagearea[j]=outimagearea[j]+(0.5+di3[j])
                 goto,jump3
              endif
              IF (ii3 EQ (ii4-1)) then begin
                 outimage[j,i]=outimage[j,i]+image[jj4-1,ii3]
                 outimagearea[j]=outimagearea[j]+1.0
                 goto,jump3
              endif
              IF (ii3 EQ (ii4+1)) AND (jj1 EQ jj3) then begin
                 outimage[j,i]=outimage[j,i]+image[jj4-1,ii3-1]
                 outimagearea[j]=outimagearea[j]+1.0 
              endif
           ENDIF
jump3:
           
           IF ((ii2 - ii4) GT 1) then begin ; y 1 pixel jump sono 2; was 4-2
              IF (jj4 EQ jj2) then begin
                 outimage[j,i]=outimage[j,i]+image[jj2,ii2+1] * (0.5+dj2[j])
                 outimagearea[j]=outimagearea[j] + (0.5+dj2[j])
                 goto,jump4
              endif
              IF (jj4 EQ (jj2-1)) AND (ii2 EQ ii1) then begin
                 outimage[j,i]=outimage[j,i]+image[jj2-1,ii2+1]
                 outimagearea[j]=outimagearea[j]+1.0
                 goto,jump4
              endif
              IF (jj4 EQ (jj2+1)) AND (ii2 EQ ii1) AND (ii3 EQ ii4) then begin
                 outimage[j,i]=outimage[j,i]+image[jj2,ii2+1]
                 outimagearea[j]=outimagearea[j]+1.0
              endif
           ENDIF
jump4:
           IF ((jj4-jj1) GT 1) AND ((ii4-ii1) GT 1) AND ((jj2-jj3) GT 1) AND ((ii3-ii2) GT 1) then begin ; whole 1 pixl jump
              outimage[j,i]=outimage[j,i]+image[jj4-1,ii4-1]
              outimagearea[j]=outimagearea[j]+1.0
           endif
           
        ENDIF                   ; of out-of-order routine
        
;   if j gt 3 and i gt 3 and outimage[j,i] GT 1.5 then message,'Finish'
                                ; debug
;print,outimage[j,i],j,i,jj1,jj2,jj3,jj4,ii1,ii2,ii3,ii4
;print,fac1a,fac2a,fac3a,fac4a     
     endfor
     outimage[*,i]=outimage[*,i]/(1.+ (fluxconserveflag EQ 0) * (outimagearea-1.))
  endfor
  
FINISH:
done:
  
; check finit/nan and replace them to zero.
  
  infinit_range=where(finite(outimage) EQ 0,count)
  if count NE 0 then outimage[infinit_range]=0.
  
END
