pro irc_edit_aperture_on_ds9,source_table,image3d,specimage3d,use_array
  common dir_structure,datadir,calibdir,datadir2,tmpdir
  
; Show/Edit apertures on spec_images with DS9
  
  user='_FOR_'+strupcase(getenv('USER'))
  ds9_title='IRC_SPECRED_EXTRACTED_IMAGES'+user
  n_source=n_elements(source_table)
  ds9_init,n_source,title=ds9_title
  ds9_make_fits_files,image3d,specimage3d
  ds9_fits_file_read,n_source,title=ds9_title
  
  s=size(specimage3d) & dx=(s[1]-1)/2 & dy=(s[2]-1)/2
  s=size(image3d) & dy=dy+s[2]  ; must add hight for bottom image view
  use_array=indgen(n_source)+1  ; array starts from 1, not from zero.
  
  ds9_make_region_files,source_table,dx,dy,use_array,regionfilename0=tmpdir+'/tmp'
  
; region file load to ds9
  ds9_region_file_load,n_source,use_array,regionfilename0=tmpdir+'/tmp',title=ds9_title
  source_table_org=source_table ; backup the original source_table
  
  spawn,'xpaset -p '+ds9_title+' tile grid mode automatic',result
  
ds9_repeat:
  
  result=dialog_message('Press here after editing on DS9',/information)
  
; active frame read
  ds9_activeframe_read,use_array,title=ds9_title
;; region file save
;;   ds9_region_file_save,n_source
;; region read directly from ds9 through xpa
  ds9_region_read,source_table,dx,dy,use_array,title=ds9_title
  
; region file update, and load
  ds9_make_region_files,source_table,dx,dy,use_array,regionfilename0=tmpdir+'/tmp'
  ds9_region_file_load,n_source,use_array,regionfilename0=tmpdir+'/tmp',title=ds9_title
  
  answer=''                     ; dummy
  read,answer,prompt='Do another iteration? [y/n] '
  if answer EQ 'y' then goto,ds9_repeat
  
  ds9_region_update,source_table,use_array
  n_source=n_elements(source_table)
  
  ds9_destroy,n_source,title=ds9_title

end
