pro ds9_make_fits_files_single,specimage3d

  common dir_structure,datadir,calibdir,datadir2,tmpdir

  s=size(specimage3d)
  if s[0] EQ 2 then n_source=1 else n_source=s[3]
  
  for i=0,n_source-1 do begin
     if n_source GT 1 then begin ; the case of 3D image
        specimage3d_bg=specimage3d[*,*,i]
     endif else begin           ; the case of 2D
        specimage3d_bg=specimage3d[*,*]
     endelse
     
     disp_image=specimage3d_bg
     
     filename=strcompress(tmpdir+'/tmp.'+string(i)+'.fits',/remove_all)
     file_delete,filename,/allow_nonexistent
     mwrfits,disp_image,filename,/silent
  endfor
end

pro irc_edit_frames_on_ds9,specimage3d,use_array

  s=size(specimage3d) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  use_array=indgen(n_frame)+1   ; array starts from 1, not from zero.

; do nothing because it is auto mode.
  if !IRC_SPECRED_PROCESSOPTION.non_interactive_mode EQ 1B || !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then return

  user='_FOR_'+strupcase(getenv('USER'))
  dx=(s[1]-1)/2 & dy=(s[2]-1)/2

  case 1 of
  (NIR()) : begin xgrid=1 & ygrid=9 & end
  (MIRS()): begin xgrid=3 & ygrid=5 & end
  (MIRL()): begin xgrid=3 & ygrid=9 & end
  endcase
  
  ds9_init,n_frame,xgrid=xgrid,ygrid=ygrid,title='IRC_SPECRED_FRAME_SELECT'+user

  if NIR() then fac=1 else fac=2
  spawn,'xpaset -p IRC_SPECRED_FRAME_SELECT'+user+' width ' +strcompress(string(s[1]*fac),/remove)
 
  ds9_make_fits_files_single,specimage3d
  ds9_fits_file_read,n_frame,title='IRC_SPECRED_FRAME_SELECT'+user
; spawn,'xpaset -p IRC_SPECRED_FRAME_SELECT'+user+' tile grid mode automatic',result
  result=dialog_message('Press here after editing on DS9',/information)
  ds9_activeframe_read,use_array,title='IRC_SPECRED_FRAME_SELECT'+user
; ds9_destroy,n_frame,title='IRC_SPECRED_FRAME_SELECT'+user
  use_array-=1                  ; subtract one for IDL frame_id

; apply mask
  for i=0,n_frame-1 do begin
     result=where(use_array EQ i,count)
     if count EQ 0 then specimage3d[*,*,i]=!values.f_nan
  endfor

end
