pro interp_response2,wave_array,response_lambda,response,d_response,response_at_lambda,d_response_at_lambda
  
  response_at_lambda=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
  d_response_at_lambda=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
  
  linterp,response_lambda,  response,wave_array,  response_at_lambda,missing=0.
  linterp,response_lambda,d_response,wave_array,d_response_at_lambda,missing=0.

end

pro irc_senscalib,specimage_n_wc,specmask_n,wave_array,source_table,specimage_n_fc,sigmaimage_n_fc, $
                  additional_wave_offset_pix=additional_wave_offset_pix,no_logger_out=no_logger_out,no_shotnoise=no_shotnoise

  common GUI,logger

; Note: specmask_n is not used in this routine.

  if keyword_set(no_logger_out) EQ 0 then logger->append,['---','Flux calibrating...']
  
  if defined(additional_wave_offset_pix) EQ 0 then additional_wave_offset_pix=0.
  
  specimage_n_fc=fltarr(size(specimage_n_wc,/dimensions))
  sigmaimage_n_fc=fltarr(size(specimage_n_wc,/dimensions))
  s=size(specimage_n_fc) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1

  set_response,response_lambda,response,d_response
  if !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy NE n_elements(response) then $
     print,'Warning (irc_senscalib): Sizes of response file and input image are not same!'
  max_response=max(response)

; Apply wavelength shift for senscalib.
  shift_response,response,d_response,additional_wave_offset_pix,response_shift,d_response_shift

;remove bad region
  good_response=where(finite(response) AND response GT 0. AND d_response GT 0.,count)
  if count GT 0 then begin
     response_shift=response_shift[good_response]
     d_response_shift=d_response_shift[good_response]
     response_lambda=response_lambda[good_response]
  endif

  xarray=make_array(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,/float,value=1.)

  interp_response2,wave_array,response_lambda,response_shift,d_response_shift,response_at_lambda,d_response_at_lambda

; plot,wave_array,response_at_lambda
; plot,response_lambda,response_shift

  for y=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1 do begin
     if (response_at_lambda[y] GT 0.) $
        && (response_at_lambda[y] GT d_response_at_lambda[y]) $
        && (response_at_lambda[y] GT max_response*0.001) $
     then begin
        response_at_lambda_array  =make_array(n_frame,/float,value=  response_at_lambda[y])
        d_response_at_lambda_array=make_array(n_frame,/float,value=d_response_at_lambda[y])

        response_at_lambda_2d  =xarray #   response_at_lambda_array
        d_response_at_lambda_2d=xarray # d_response_at_lambda_array
        spec_bgnoise_ADU_2d    =xarray # source_table.spec_bgnoise_ADU

        specimage_n_fc[*,y,*]=specimage_n_wc[*,y,*]/response_at_lambda_2d
        if keyword_set(no_shotnoise) then $
           sigmaimage_n_fc[*,y,*]=spec_bgnoise_ADU_2d/response_at_lambda_2d else $
              sigmaimage_n_fc[*,y,*]=sqrt((spec_bgnoise_ADU_2d/response_at_lambda_2d)^2. $
                                          +(specimage_n_wc[*,y,*]/response_at_lambda_2d^2.*d_response_at_lambda_2d)^2.) ; with photon shot noise
     endif else begin           ; when response is zero or less...
        specimage_n_fc[*,y,*]=0. & sigmaimage_n_fc[*,y,*]=0.
     endelse
  endfor

end
