pro irc_skysub_fit,image,mask,image_bg,sigma,fitorder=fitorder,sub_local_sky=sub_local_sky,short=short

  if !IRC_SPECRED_OBSPARAM.Np_mode || !IRC_SPECRED_OBSPARAM.slit_mode then begin
     image_bg=image
     sigma=0
     return
  endif
  
; low-order sky fit (2D) is made with mask.
  skyrej_sigma=1.5
  
  s=size(image) & xsize=s[1] & ysize=s[2]
  n_image=n_elements(image)
  
  if defined(fitorder) then $
     sky_fit_order_local=fitorder $
  else $
     sky_fit_order_local=!IRC_SPECRED_SKYFITORDER.sky_fit_order
  
  if keyword_set(short) then sky_fit_order_local=0

  if xsize LT 250 then begin
     sky_x1=0 & sky_x2=xsize-1 & sky_y1=0 & sky_y2=ysize-1
;  sky_fit_order_local=1
     mask_range=where(finite(mask,/NAN),n_badarea)
     n_badarea2=0
  endif else begin
     sky_x1=!IRC_SPECRED_AREAINFO.sky_x1
     sky_x2=!IRC_SPECRED_AREAINFO.sky_x2
     sky_y1=!IRC_SPECRED_AREAINFO.sky_y1
     sky_y2=!IRC_SPECRED_AREAINFO.sky_y2
     
     irc_calcsky_mmm,image,skymod,sigma
     mask_range=where(finite(mask*image,/NAN),n_badarea)
     mask_range2=where(image GT skymod+skyrej_sigma*sigma OR image LT skymod-skyrej_sigma*sigma,n_badarea2)
  endelse
  
  if n_badarea GT 0.90*n_image then begin
     print,'Warning (irc_skysub_fit): Available sky area is too small! '+strim(n_image-n_badarea)+' (pix)'
     sigma=0.
     image_bg=image
     return
  endif
  
  image2=image
  if n_badarea  GT 0 then image2[mask_range] =-9999.
  if n_badarea2 GT 0 then image2[mask_range2]=-9999.
  image3=image
  if n_badarea  GT 0 then image3[mask_range] =!values.f_nan
  if n_badarea2 GT 0 then image3[mask_range2]=!values.f_nan
  
;mask_grow,image3,image4
  
  if sky_fit_order_local NE 0 then begin
                                ; real fit
     fit_sky2d_tmp=rob_mapfit( $
                   sigma_filter(image2[sky_x1:sky_x2,sky_y1:sky_y2],radius=1,/all,/iterate), $
                   sky_fit_order_local,coef,sigma,floor=-9990.)
                                ; fake fit for sigma calc
  endif
  
  fit_sky2d=fltarr(size(image,/dimensions))
  case sky_fit_order_local of
     0: begin                   ; for 0th order fit
        irc_mmm,image2[sky_x1:sky_x2,sky_y1:sky_y2],skymod,sigma
        fit_sky2d[*,*]=skymod
     end
     
     1: begin
        for y=0,ysize-1 do begin for x=0,xsize-1 do begin
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*y
        endfor & endfor
     end
     2: begin
        for y=0,ysize-1 do begin for x=0,xsize-1 do begin
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*x^2.+coef[3]*x*y+coef[4]*y+coef[5]*y^2.
        endfor & endfor
     end
     3: begin
        for y=0D,ysize-1 do begin for x=0D,xsize-1 do begin
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*y+coef[3]*x^2.+coef[4]*y^2.+coef[5]*x*y+coef[6]*x^3.+coef[7]*y^3.+coef[8]*x^2.*y+coef[9]*x*y^2.
        endfor & endfor
     end
     
     4: begin
        for y=0D,ysize-1 do begin for x=0D,xsize-1 do begin 
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*y+coef[3]*x^2.+coef[4]*y^2+coef[5]*x*y+coef[6]*x^3.+coef[7]*y^3.+coef[8]*x^2.*y+coef[9]*x*y^2.+coef[10]*x^4.+coef[11]*y^4.+coef[12]*x^3.*y+coef[13]*y^3.*x+coef[14]*x^2.*y^2.
        endfor & endfor
     end
     5: begin
        for y=0D,ysize-1 do begin for x=0D,xsize-1 do begin
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*y+coef[3]*x^2.+coef[4]*y^2.+coef[5]*x*y+coef[6]*x^3.+coef[7]*y^3.+coef[8]*x^2.*y+coef[9]*x*y^2. $
                          +coef[10]*x^4.+coef[11]*y^4.+coef[12]*x^3.*y+coef[13]*y^3.*x+coef[14]*x^2.*y^2.+coef[15]*x^5.+coef[16]*y^5.+coef[17]*x^4.*y $
                          +coef[18]*y^4.*x+coef[19]*x^3.*y^2.+coef[20]*x^2.*y^3.
        endfor & endfor
     end
     
     6: begin
        for y=0D,ysize-1 do begin for x=0D,xsize-1 do begin
           fit_sky2d[x,y]=coef[0]+coef[1]*x+coef[2]*y+coef[3]*x^2.+coef[4]*y^2.+coef[5]*x*y+coef[6]*x^3.+coef[7]*y^3.+coef[8]*x^2.*y+coef[9]*x*y^2.+coef[10]*x^4.+coef[11]*y^4.+coef[12]*x^3.*y+coef[13]*y^3.*x+coef[14]*x^2.*y^2.+coef[15]*x^5.+coef[16]*y^5.+coef[17]*x^4.*y+coef[18]*y^4.*x+coef[19]*x^3.*y^2.+coef[20]*x^2.*y^3.+coef[21]*x^6.+coef[22]*y^6.+coef[23]*x^5.*y+coef[24]*y^5.*x+coef[25]*x^4.*y^2.+coef[26]*y^4.*x^2.+coef[27]*x^3.*y^3.
        endfor & endfor
     end
     
  endcase
  
  image_bg=image-fit_sky2d
  image_bg3=image3-fit_sky2d
  if n_badarea  GT 0 then image_bg3[mask_range] =!values.f_nan
  if n_badarea2 GT 0 then image_bg3[mask_range2]=!values.f_nan
  
end
