PRO irc_skysub_indivframe,inimage,outimage,weight=weight,short=short

  common GUI,logger

  s=size(inimage) & ncol=s[1] & nrow=s[2] & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  mask=make_array(ncol,nrow,/float,value=1.) ; dummy mask (not masked at all!)
  outimage=fltarr(ncol,nrow,n_frame)
  weight=fltarr(n_frame)

  logger->append,['  skysub residual RMS (ADU):']

  case 1 of
     (NP() || NG() || SG1() || SG2()): begin
        for i=0,n_frame-1 do begin
           irc_skysub_fit,inimage[*,*,i],mask,tmp,sigma,/sub_local_sky,fitorder=sky_fit_indiv_order,short=short
           outimage[*,*,i]=tmp
           weight[i]=1./sigma^2.
           logger->append,['    Subframe id'+string(i)+': '+string(sigma)]
        endfor
     end
;     (SG2()): begin
;        for i=0,n_frame-1 do begin
;           irc_skysub_adopt,inimage[*,*,i],mask,tmp,sigma,x=20,y=3
;           outimage[*,*,i]=tmp
;           weight[i]=1./sigma^2.
;        endfor
;     end
     (LG2()): begin
        if !IRC_SPECRED_PROCESSOPTION.simple_skysub_mode then begin
           print,'Information (irc_skysub_indivframe): This is simple skysub mode.'
           simple=1
        endif
        for i=0,n_frame-1 do begin
           irc_skysub_adopt,inimage[*,*,i],mask,tmp,sigma,x=17,y=5,simple=simple ; should be odd number for loess; was 21
           outimage[*,*,i]=tmp
           weight[i]=1./sigma^2.
           logger->append,['    Subframe id'+string(i)+': '+string(sigma)]
        endfor
     end
  endcase
  
END
