pro irc_skysub_n,source_table,specimage3d,specmask3d_remove_all_source,specimage3d_bg,sigma_ADU, $
                 mmm=mmm,weightmap3d=weightmap3d,noisemap3d=noisemap3d

  common gui,logger

  n_source=n_elements(source_table)
  specimage3d_bg=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
  sigma_ADU=fltarr(n_source)
  sigma_array=fltarr(n_source)
  total_weight_array=fltarr(n_source)

  if ~ defined(weightmap3d) then weightmap3d=make_array(size(specimage3d,/dimensions),value=1.0,/float)
  if ~ defined(noisemap3d) then noisemap3d=make_array(size(specimage3d,/dimensions),value=1.0,/float)

  logger->append,['  typical sky count (ADU)']

  for source_id=0,n_source-1 do begin
     mask=specmask3d_remove_all_source[*,*,source_id];*noisemap3d[*,*,source_id]

     if ~ keyword_set(mmm) then begin
        irc_skysub_spec,specimage3d[*,*,source_id],mask,specimage3d_bg_tmp,sigma, $
                        skymod=skymod,weightmap=weightmap3d[*,*,source_id],total_weight=total_weight
        specimage3d_bg[*,*,source_id]=specimage3d_bg_tmp
        sigma_array[source_id]=sigma
        total_weight_array[source_id]=total_weight

        if sigma GT 0. && abs(skymod) GT sigma*1.5 $
           && (!IRC_SPECRED_OBSPARAM.slit_mode EQ 0B && !IRC_SPECRED_OBSPARAM.Np_mode EQ 0B) then $
           print,'Warning (irc_skysub_n): sky level is larger than 1.5 times sky sigma! at source id of '+strim(source_id)
        if sigma LE 0 then begin
           irc_skysub_mean,specimage3d[*,*,source_id],mask, $
                           0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1,0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1,skymod,sigma, $
                           weightmap=weightmap3d[*,*,source_id]
           specimage3d_bg[*,*,source_id]=specimage3d[*,*,source_id]-skymod
           sigma_array[source_id]=sigma
        endif
     endif else begin           ; use mmm for sky
        irc_skysub_mean,specimage3d[*,*,source_id],mask, $
                        0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1,0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1,skymod,sigma, $
                        weightmap=weightmap3d[*,*,source_id]
        specimage3d_bg[*,*,source_id]=specimage3d[*,*,source_id]-skymod
        sigma_array[source_id]=sigma

     endelse
     
     logger->append,['    Source id'+string(source_id)+': '+string(skymod)+'+-'+string(sigma)]
  endfor

  nonzero=where(sigma_array GT 0.,count)
  if count GT 0 then begin
     if total(total_weight_array) NE 0 then $
        meanclip_mod,sigma_array[nonzero],mean_sigma,tmp_sigma,weight=total_weight_array[nonzero],clipsig=3. $
     else $
        meanclip_mod,sigma_array[nonzero],mean_sigma,tmp_sigma,clipsig=3.
  endif else $
      mean_sigma=0.

  sigma_ADU[*]=mean_sigma
 
end
