pro irc_skysub_spec,image,mask,image_bg,sigma, $
                    skymod=skymod,weightmap=weightmap,total_weight=total_weight

  s=size(image) & xsize=s[1] & ysize=s[2]
  n_pix=n_elements(image)
  image_bg=image

  if ~ defined(weightmap) then weightmap=make_array(size(image,/dimensions),/float,value=1.0)
  inf_nan=where(finite(weightmap,/NAN) OR finite(weightmap,/INFINITY),count)
  if count GT 0 then weightmap[inf_nan]=0.
  
  mask_range=where(finite(mask,/NAN),n_badarea)
  if n_badarea GT 0.90*n_pix then begin
     n_remaining=n_pix-n_badarea
;    print,'Warning (irc_skysub_spec): Available (non-masked) sky area is too small! '+strim(n_remaining)+' (pix)'
     sigma=0.
     total_weight=0.
     return
  endif

  image_sigma=sigma_filter(image,radius=3,/all,/iter,n_sigma=3.0)
  image_masked=image_sigma
  if n_badarea GT 0 then image_masked[mask_range]=!values.f_nan
  
  xarray=findgen(xsize)
  sigma_array=fltarr(ysize)
  total_weight_array=fltarr(ysize)
  if NG() then fit_y_width=1 else fit_y_width=5 ; was 2
  if NIR() then clip_sigma=1.5 else clip_sigma=3.0

  for y=0,ysize-1 do begin
     bg_1d=image_masked[3:xsize-3,(y-fit_y_width)>0:(y+fit_y_width)<(ysize-1)]
     weight_1d=weightmap[3:xsize-3,(y-fit_y_width)>0:(y+fit_y_width)<(ysize-1)]
     image_1d=image[*,y]
     nonnan=where(finite(bg_1d),count)
     total_weight_tmp=0.
     case 1 of
        (count GT 5): begin
           meanclip_mod,bg_1d[nonnan],sky,sigma_tmp,clipsig=clip_sigma,weight=weight_1d[nonnan]
           meanclip_mod,bg_1d[nonnan],sky_tmp,sigma,clipsig=3.0,weight=weight_1d[nonnan]
           total_weight_tmp=total(weight_1d[nonnan],/NAN)
        end
        (count GT 3 && count LE 5): begin
           sky=median(bg_1d[nonnan])
           sigma=stddev(bg_1d[nonnan])
        end
        (count GT 0 && count LE 3): begin
           sky=median(bg_1d[nonnan])
           sigma=-1.
        end
        (count EQ 0): begin
           sky=0.
           sigma=-1.
        end
     endcase
     image_bg[*,y]=image_1d-sky
     sigma_array[y]=sigma
     total_weight_array[y]=total_weight_tmp
  endfor
  
  skyimage=image-image_bg

  skymod=median(skyimage)
  nonzero=where(sigma_array GT 0,count)
  case 1 of
     (count GT 5): meanclip_mod,sigma_array[nonzero],sigma,sigma_sigma,clipsig=3.
     (count EQ 1): sigma=sigma_array[nonzero]
     (count EQ 0): sigma=-1
     else: sigma=median(sigma_array[nonzero])
  endcase

  if count GT 0 then total_weight=mean(total_weight_array[nonzero],/NAN) else total_weight=1.

end
