pro irc_source_detect_extract2,image,specimage,ext_source_table, $ ; inputs
                               source_table, $ ; main outputs
                               image_bg,specimage_bg,image3d_bg,specimage3d_bg, $
                               res_image_bg,res_specimage_bg, $
                               mask_image,mask_specimage, $
                               fov_mask=fov_mask, $
                               source_table_offset_x_value=source_table_offset_x_value, $
                               source_table_offset_y_value=source_table_offset_y_value, $
                               noisemap_whole=noisemap_whole,noisemap_n=noisemap_n,noise_mask=noise_mask

; Source detection and extraction
;
; INPUTS:
; - image & spec image (2D or 3D array). 3rd dimension for a series of frames.
; - ext_source_table: file name of external source table (*.tbl).
;  if '', then internal source detection program will be used.
;
; OUTPUTS:
; - source_table: the source table
; - image3d: images of N targets
; - specimage3d: 2d spectra of N targets
; - res_image_bg/res_specimage_bg: residual image/specimage, with
;   target masked, and background subtracted.
; - mask_image/mask_specimage: mask image

  common gui,logger

  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B then logger->append,['---','Detecting and extracting sources...']

if NP() then skyrej_sigma=1.5 else skyrej_sigma=3.0

; change the following to select short or long
; short image is good for over-saturated images.
  image_short=image[*,*,0] & image_long=image[*,*,1]
  if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
     image_use=image_short $
  else $
     image_use=image_long
  
  specimage_short=specimage[*,*,0] & specimage_long=specimage[*,*,1]
  
; create a dummy output
  image_bg=image & res_image_bg=image_bg
  specimage_bg=specimage & res_specimage_bg=specimage
  
; Do sky fit over whole FOV and subtraction.
; SPEC
  if !IRC_SPECRED_OBSPARAM.slit_mode || !IRC_SPECRED_OBSPARAM.Np_mode then begin ;no skysub for slit.
     specimage_bg_tmp      =specimage_long
     specimage_bg_short_tmp=specimage_short
     sigma_spec=0.              ; dummy
     image_bg_tmp      =image_long
     image_bg_short_tmp=image_short
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        image_bg_use_tmp=image_bg_short_tmp $
     else $
        image_bg_use_tmp=image_bg_tmp
  endif else begin
; 1st attempt: do with find only for sky sub
     logger->append,['Source extraction... pass 1']
     irc_specext,image_use,specimage_long,source_table_dummy,image3d,specimage3d,'', $
                 /auto_specbox_x_shift,/no_mask,noise_for_find=noise_for_find,/for_skysub_only, $
                 source_table_offset_x_value=source_table_offset_x_value, $
                 source_table_offset_y_value=source_table_offset_y_value,fov_mask=fov_mask, $
                 noisemap_whole=noisemap_whole,noisemap_n=noisemap_n
     
     make_wholemask,source_table_dummy.spec_x,source_table_dummy.spec_y, $
                    source_table_dummy.spec_mask_dx,source_table_dummy.spec_mask_dy, $
                    mask_specimage,fov_mask=fov_mask

     noise_mask=mask_specimage
     noise_mask[*,*]=1.
     if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0 && defined(noisemap_whole) then begin
        irc_calcsky_mmm,noisemap_whole,noisemod,noisesigma
        noisemask_range=where(noisemap_whole GT noisemod+skyrej_sigma*noisesigma OR $
                              noisemap_whole LT noisemod-skyrej_sigma*noisesigma,n_badarea)
        if n_badarea GT 0 then noise_mask[noisemask_range]=!values.f_nan
        mask_grow,noise_mask,noise_mask_grow,grow_width=1
        noise_mask=noise_mask_grow
        mask_specimage*=noise_mask
     endif

     logger->append,['    Sky-subtracting (global) from combined images...']
     irc_skysub_fit,specimage_long, mask_specimage,specimage_bg_tmp,      sigma_spec
     irc_skysub_fit,specimage_short,mask_specimage,specimage_bg_short_tmp,sigma_spec_short
     
; IMAG
     make_wholemask,source_table_dummy.image_x,source_table_dummy.image_y, $
                    source_table_dummy.image_mask_dx,source_table_dummy.image_mask_dy, $
                    mask_image, /circular_aperture,fov_mask=fov_mask
     irc_skysub_fit,image_long, mask_image,image_bg_tmp,      sigma_tmp
     irc_skysub_fit,image_short,mask_image,image_bg_short_tmp,sigma_short_tmp
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        image_bg_use_tmp=image_bg_short_tmp $
     else $
        image_bg_use_tmp=image_bg_tmp

; 2nd attempt: no find, just extraction, with sky-subtracted images
     logger->append,['Source extraction... pass 2']
  
  endelse
  
  if !IRC_SPECRED_OBSPARAM.slit_mode then logger->append,['---','Slit extracting...']

  irc_specext,image_bg_use_tmp,specimage_bg_tmp,source_table,image3d_bg_tmp,specimage3d_bg_tmp,ext_source_table, $
              noise_for_find=noise_for_find, $ ;/auto_specbox_x_shift, $
              source_table_offset_x_value=source_table_offset_x_value, $
              source_table_offset_y_value=source_table_offset_y_value,fov_mask=fov_mask, $
              noisemap_whole=noisemap_whole,noisemap_n=noisemap_n
  
  make_wholemask,source_table.spec_x,source_table.spec_y, $
                 source_table.spec_mask_dx,source_table.spec_mask_dy, $
                 mask_specimage,fov_mask=fov_mask
  
  make_wholemask,source_table.image_x,source_table.image_y, $
                 source_table.image_mask_dx,source_table.image_mask_dy, $
                 mask_image, /circular_aperture,fov_mask=fov_mask

  noise_mask=mask_specimage
  noise_mask[*,*]=1.  
  if !IRC_SPECRED_OBSPARAM.preflight_mode EQ 0 && defined(noisemap_whole) then begin
     irc_calcsky_mmm,noisemap_whole,noisemod,noisesigma
     noisemask_range=where(noisemap_whole GT noisemod+skyrej_sigma*noisesigma OR $
                           noisemap_whole LT noisemod-skyrej_sigma*noisesigma,n_badarea)
     if n_badarea GT 0 then noise_mask[noisemask_range]=!values.f_nan
     mask_grow,noise_mask,noise_mask_grow,grow_width=1
     noise_mask=noise_mask_grow
     mask_specimage*=noise_mask
  endif
  
; check spec aperture with ds9
  if !IRC_SPECRED_PROCESSOPTION.ds9_edit_mode then begin
     irc_edit_aperture_on_ds9,source_table,image3d_bg_tmp,specimage3d_bg_tmp,use_array
; again (last), do sky fit over whole FOV and subtraction, with modified mask info.
; for spec
     if !IRC_SPECRED_OBSPARAM.slit_mode then begin ; no sky sub at slit
        specimage_bg=      specimage_long
        specimage_bg_short=specimage_short
     endif else begin
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       source_table.spec_mask_dx,source_table.spec_mask_dy, $
                       mask_specimage,fov_mask=fov_mask
        irc_skysub_fit,specimage_long, mask_specimage,specimage_bg,      sigma_spec
        irc_skysub_fit,specimage_short,mask_specimage,specimage_bg_short,sigma_spec_short
     endelse
; for imag
     make_wholemask,source_table.image_x,source_table.image_y, $
                    source_table.image_mask_dx,source_table.image_mask_dy, $
                    mask_image,/circular_aperture,fov_mask=fov_mask
     irc_skysub_fit,image_long ,mask_image,image_bg,sigma
     irc_skysub_fit,image_short,mask_image,image_bg_short,sigma_short
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        image_bg_use=image_bg_short_tmp $
     else $
        image_bg_use=image_bg
     
; 3rd (last) attempt: no find, just extraction, with better sky-subtracted images
     logger->append,['Source extraction... pass 3']
     irc_specext,image_bg_use,specimage_bg,source_table,image3d_bg,specimage3d_bg,ext_source_table, $
                 /no_mask,noise_for_find=noise_for_find, $
                 source_table_offset_x_value=source_table_offset_x_value, $
                 source_table_offset_y_value=source_table_offset_y_value,fov_mask=fov_mask, $
                 noisemap_whole=noisemap_whole,noisemap_n=noisemap_n
     
  endif else begin
     image_bg[*,*,1]      =image_bg_tmp
     image_bg_short=image_bg_short_tmp
     image_bg[*,*,0]=image_bg_short
     specimage_bg[*,*,1]      =specimage_bg_tmp
     specimage_bg_short=specimage_bg_short_tmp
     specimage_bg[*,*,0]=specimage_bg_short
     specimage3d_bg=specimage3d_bg_tmp
     image3d_bg    =image3d_bg_tmp
  endelse
  
  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B then begin
     res_specimage_bg[*,*,0]=specimage_bg[*,*,0]*mask_specimage
     res_specimage_bg[*,*,1]=specimage_bg[*,*,1]*mask_specimage
     res_image_bg[*,*,0]    =image_bg[*,*,0]    *mask_image
     res_image_bg[*,*,1]    =image_bg[*,*,1]    *mask_image
  endif
  
; set whole-sky sigma for all the noise for each extracted image.
  source_table[*].spec_bgnoise_ADU=sigma_spec
  
end
