PRO irc_specext,image,specimage,source_table,image3d,specimage3d,ext_source_table, $
                noise_for_find=noise_for_find,FWHM=FWHM, $
                auto_specbox_x_shift=auto_specbox_x_shift, $
                for_skysub_only=for_skysub_only,skysub=skysub, $
                fov_mask=fov_mask,no_mask=no_mask, $
                source_table_offset_x_value=source_table_offset_x_value, $
                source_table_offset_y_value=source_table_offset_y_value, $
                noisemap_whole=noisemap_whole,noisemap_n=noisemap_n
 
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  common gui,logger
  
  if ~ defined(source_table) then make_default_source_table,source_table

  if ~ defined(noise_for_find) then autonoisecalc=1B
  if ~ keyword_set(FWHM) then FWHM=!IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find

  tmp=where(source_table.image_x NE 0,n_source)
  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 1B then set_slitpos,source_table else begin
     case 1 of
        (strlen(ext_source_table) EQ 0 && n_source EQ 0 && ~ keyword_set(for_skysub_only)): $
           ircfind,image,source_table,fwhm, $
                   /interactive,/autonoisecalc,noise_for_find=noise_for_find,skysub=skysub
        (strlen(ext_source_table) EQ 0 && n_source EQ 0 && keyword_set(for_skysub_only)): $
           ircfind,image,source_table,fwhm, $
                   /autonoisecalc,noise_for_find=noise_for_find,skysub=skysub,/only_bright_objects,/for_skysub_only ;,/no_photo
        (strlen(ext_source_table) EQ 0 && n_source GT 0): $
           ircfind,image,source_table,fwhm, $
                   /autonoisecalc,noise_for_find=noise_for_find,skysub=skysub
        (strlen(ext_source_table) NE 0 && keyword_set(for_skysub_only)): $
           ircfind,image,source_table,fwhm, $
                   /autonoisecalc,noise_for_find=noise_for_find,skysub=skysub,/only_bright_objects,/for_skysub_only ;,/no_photo
        (strlen(ext_source_table) NE 0 && ~ keyword_set(for_skysub_only)): $
           load_ext_source_table,source_table,ext_source_table,image=image, $
                                 source_table_offset_x_value=source_table_offset_x_value, $
                                 source_table_offset_y_value=source_table_offset_y_value
     endcase
  endelse
  
; Set specbox info
  calc_specbox_pos,source_table
  
; Do source extraction
  make_image_n,image,specimage,source_table,image3d,specimage3d
  if defined(noisemap_whole) then make_image_n,noisemap_whole[*,*,1],noisemap_whole[*,*,1],source_table,tmp,noisemap_n
  make_mask_n,source_table,mask_specimage_n,fov_mask=fov_mask
  make_mask_n,source_table,mask_specimage_n_remove_all,/remove_all_source,fov_mask=fov_mask

  if (!IRC_SPECRED_OBSPARAM.slit_mode EQ 0B) then begin ; && keyword_set(auto_specbox_x_shift)
     if keyword_set(no_mask) then mask_specimage_n[*,*,*]=1.
; calc shift value
     if (!IRC_SPECRED_OBSPARAM.Np_mode EQ 1B || SG2() || LG2()) && keyword_set(for_skysub_only) then begin
        case 1 of
           (NP()): begin
              read_specbox_shift_x,mean_d_offset,filename=workdir+'/NP_SPECBOX_SHIFT_X.dat'
              print,'Information (irc_specext): read specbox X shift info from NP shift database.'
           end
           (NG()): begin
              read_specbox_shift_x,mean_d_offset,filename=workdir+'/NG_SPECBOX_SHIFT_X.dat'
              print,'Information (irc_specext): read specbox X shift info from NG shift database.'
           end
           (SG2()): begin
              if !IRC_SPECRED_OBSPARAM.AOT EQ '04A' then begin
                 read_specbox_shift_x,mean_d_offset,filename=workdir+'/NP_SPECBOX_SHIFT_X.dat' 
                 print,'Information (irc_specext): read specbox X shift info from NP shift database.'
              endif else begin
                 read_specbox_shift_x,mean_d_offset,filename=workdir+'/NG_SPECBOX_SHIFT_X.dat'
                 print,'Information (irc_specext): read specbox X shift info from NG shift database.'
              endelse
              mean_d_offset*=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x
           end
           (LG2()): begin
              if !IRC_SPECRED_OBSPARAM.AOT EQ '04A' || !IRC_SPECRED_OBSPARAM.AOT EQ '04C' then begin
                 read_specbox_shift_x,mean_d_offset,filename=workdir+'/NP_SPECBOX_SHIFT_X.dat'
                 print,'Information (irc_specext): read specbox X shift info from NP shift database.'
              endif else begin
                 read_specbox_shift_x,mean_d_offset,filename=workdir+'/NG_SPECBOX_SHIFT_X.dat'
                 print,'Information (irc_specext): read specbox X shift info from NG shift database.'
              endelse
;             print,mean_d_offset
              mean_d_offset*=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x
           end
        endcase
        sigma_mean_d_offset=0.
     endif else begin
        if keyword_set(for_skysub_only) then begin
           logger->append,['  measuring X pos of spec images... pass 1']
           calc_shift_specbox_x,specimage3d,mask_specimage_n,mask_specimage_n_remove_all,source_table, $
                                mean_d_offset,sigma_mean_d_offset,skysub=skysub
        endif else begin
           mean_d_offset=0.
           sigma_mean_d_offset=0.
        endelse
     endelse

; apply X offset
     !IRC_SPECRED_SPECEXTRACTPARAM.x_offset+=mean_d_offset[0]
     source_table.spec_x+=mean_d_offset[0]
     logger->append,['  mean specbox X offset: '+strim(mean_d_offset[0])+'+-'+strim(sigma_mean_d_offset[0])+' (pix)']
; make final mask/specimage3d
     make_image_n,image,specimage,source_table,image3d,specimage3d
     make_mask_n,source_table,mask_specimage_n,fov_mask=fov_mask
     if keyword_set(for_skysub_only) then begin
        if NP() then write_specbox_shift_x,mean_d_offset[0],filename=workdir+'/NP_SPECBOX_SHIFT_X.dat'
        if NG() then write_specbox_shift_x,mean_d_offset[0],filename=workdir+'/NG_SPECBOX_SHIFT_X.dat'
     endif
  endif
  
END
