pro calc_flatlambda,x,y,flat1,flat2,specflatorg,lambda1,lambda2,lambda,flat
  xr=round(x) & yr=round(y)
; flat=(flat2[xr,yr]-flat1[xr,yr])/(lambda2-lambda1)*(lambda-lambda1)+flat1[xr,yr]
  flat=((flat2[xr,yr]-flat1[xr,yr])/(lambda2-lambda1)*(lambda-lambda1)+flat1[xr,yr])/specflatorg[xr,yr]
end

pro calc_specflat,source_table,flat1,flat2,specflatorg,lambda1,lambda2,specflat_n

n_source=n_elements(source_table)
specflat_n=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
interp_flat=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
lambda=wavelength_func()

get_chip_dims,ncol,nrow

for source_id=0,n_source-1 do begin
   for y=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1 do begin
      for x=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1 do begin
         xorg=get_xorg(source_table,source_id,x) < (ncol-1) > 0
         yorg=get_yorg(source_table,source_id,y) < (nrow-1) > 0
         calc_flatlambda,xorg,yorg,flat1,flat2,specflatorg,lambda1,lambda2,lambda[y],interp_flat_tmp
         interp_flat[x,y]=interp_flat_tmp
      endfor
   endfor
   specflat_n[*,*,source_id]=interp_flat
endfor                          ; of source_id

end

pro irc_specflat,specimage_n,source_table,specimage_n_sff

set_specflat,imagflat1,imagflat2,specflatorg,lambda1,lambda2
calc_specflat,source_table,imagflat1,imagflat2,specflatorg,lambda1,lambda2,specflat_n
specimage_n_sff=specimage_n/specflat_n

end
