Pro irc_specred,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec, $
                Root_dir=root_dir, $
                Ns_spec=Ns_spec,Nh_spec=Nh_spec,Np_spec=Np_spec,Ls_spec=Ls_spec, $
                brightest_10_source=brightest_10_source, $
                no_tune_sourcepos=no_tune_sourcepos, $
                use_short_refimage=use_short_refimage, $
                interactive_skyset=interactive_skyset, $
                ds9_edit=ds9_edit,no_show_ds9=no_show_ds9, $
                no_short=no_short, $
                streak_cor=streak_cor, $
                rotated_NIR_source_table=rotated_NIR_source_table, $
                source_table_offset_x_value=source_table_offset_x_value, $
                source_table_offset_y_value=source_table_offset_y_value, $
                preflight_data=preflight_data,NP_linear=NP_linear,no_NP_distortion=no_NP_distortion,debug=debug, $
                auto_image_stack=auto_image_stack,no_slit_flat=no_slit_flat,no_database_check=no_database_check, $
                no_fov_mask=no_fov_mask,non_interactive=non_interactive,simple_skysub=simple_skysub, $
                use_all_images=use_all_images,no_message_finish=no_message_finish
  
; parameter check
  if N_params() NE 6 then message,'Error (irc_specred): Wrong number of arguments!'
  
; Definitions of common blocks
  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  common frame_type,chip,filter,grism
  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
  common measured_offsets,space_shift,nsum
  common gui,logger
  
; Initialization
  init_specred,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec, $
               Root_dir=root_dir, $
               Ns_spec=Ns_spec,Nh_spec=Nh_spec,Np_spec=Np_spec,Ls_spec=Ls_spec, $
               brightest_10_source=brightest_10_source, $
               no_tune_sourcepos=no_tune_sourcepos, $
               use_short_refimage=use_short_refimage, $
               interactive_skyset=interactive_skyset, $
               ds9_edit=ds9_edit, $
               no_short=no_short, $
               rotated_NIR_source_table=rotated_NIR_source_table, $
               preflight_data=preflight_data,NP_linear=NP_linear,no_NP_distortion=no_NP_distortion,debug=debug, $
               auto_image_stack=auto_image_stack,no_slit_flat=no_slit_flat,no_database_check=no_database_check, $
               no_fov_mask=no_fov_mask,non_interactive=non_interactive,simple_skysub=simple_skysub, $
               use_all_images=use_all_images

  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then begin
     catch,error_status
     if error_status NE 0 then begin
        print,'Error was detected! Exiting...'
        exit,status=error_status
     endif
  endif
                 
; Data processing begins here.

  do_load_images,ext_source_table,refimage_list,specimage_list,darkimage_list, $
                 refimage,refimage_short,specimage,specimage_short, $
                 imagheader,specheader, $
                 superdark,imageflat,specflat,flatcor,refdark

  do_hotpixsub,refimage,refimage_short,specimage,specimage_short,refdark,superdark,refimage_hs,specimage_hs
 
  do_darksub,refimage_hs,refimage_short,specimage_hs,specimage_short,superdark,refdark, $
             refimage_ds,refimage_ds_short,specimage_ds,specimage_ds_short;, $
;             superdark_combined=superdark_combined,refdark_combined=refdark_combined,hotpix_image=hotpix_image
 
  do_linear_cor,refimage_ds,refimage_ds_short,specimage_ds,specimage_ds_short, $
                refimage_lc,refimage_lc_short,specimage_lc,specimage_lc_short

  do_flatcalib,refimage_lc,refimage_lc_short,specimage_lc,specimage_lc_short,imageflat,specflat, $
               refimage_ff,refimage_ff_short,specimage_ff,specimage_ff_short

  apply_outlier_saturation_mask,specimage_ff,specimage_ff_short,specimage_ff_mask,specimage_ff_short_mask, $
                                fov_mask=fov_mask
  apply_outlier_saturation_mask, refimage_ff, refimage_ff_short, refimage_ff_mask, refimage_ff_short_mask, $
                                 /IMAG

  do_skysub_indivframe, $
     refimage_ff_mask,specimage_ff_mask,refimage_ss_mask,specimage_ss_mask, $
     refimage_ff_short_mask,specimage_ff_short_mask,refimage_ss_short_mask,specimage_ss_short_mask, $
     weight_spec=weight_spec,weight_ref=weight_ref

  irc_edit_frames_on_ds9,specimage_ss_mask,use_array

  do_image_combine,refimage_ss_mask,refimage_ss_short_mask,refimage_ff, $
                   specimage_ss_mask,specimage_ss_short_mask,specimage_ff, $
                   weight_spec=weight_spec,weight_ref=weight_ref,noisemap=noisemap

  do_correct_saturation,refimage_ff,refimage_ff_cor
;  refimage_ff_cor=refimage_ff

  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 0B && keyword_set(no_show_ds9) EQ 0 then begin
     show_aperture_on_ds9,specimage_ff,source_table
     show_aperture_on_ds9,refimage_ff_cor,source_table,/IMAG
  endif
  
  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then begin
     process_header,specheader,imagheader,source_table,specheader_extract,imagheader_extract
     
     logger->append,['---','All done (only for whole image stacking).']
     
     write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                      refimage_ff,specimage_ff,refimage_n_bg,specimage_n_wc,specimage_n_fc,res_refimage_bg,res_specimage_bg, $
                      mask_refimage,mask_specimage,mask_specimage_n, $
                      imagheader,specheader,imagheader_extract,specheader_extract, $
                      noisemap,noisemap_n,noise_mask, $
                      dir=workdir
     exit, status=0             ; normal end
  end
  
; Target detection/sky subtraction/sub-aperture extraction
  irc_source_detect_extract2,refimage_ff_cor,specimage_ff,ext_source_table,source_table, $
                             refimage_bg,specimage_bg,refimage_n_bg,specimage_n, $
                             res_refimage_bg,res_specimage_bg, $
                             mask_refimage,mask_specimage, $
                             source_table_offset_x_value=source_table_offset_x_value, $
                             source_table_offset_y_value=source_table_offset_y_value,fov_mask=fov_mask, $
                             noisemap_whole=noisemap,noisemap_n=noisemap_n,noise_mask=noise_mask

  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B && !IRC_SPECRED_OBSPARAM.AOT NE '02B' && keyword_set(streak_cor) EQ 1 then begin
     specimage_bg_0=specimage_bg
     irc_streakcor,specimage_bg,res_specimage_bg,specimage_bg_streakcor
     specimage_bg=specimage_bg_streakcor
  endif
  
; do further skysub for each extracted spec image
  do_skysub_n,source_table,specimage_n,mask_specimage_n,specimage_n_bg, $
              fov_mask=fov_mask,mask_specimage_n_remove_all_source=mask_specimage_n_remove_all_source, $
              noisemap_n=noisemap_n,noise_mask=noise_mask
  
; Do lambda_dependent flat_fielding
  do_specflat,specimage_n_bg,source_table,specimage_n_sff
  
; Do wavelength calibration
  do_wavecalib,specimage_n_sff,source_table,specimage_n_wc,wave_array, $
               use_array=use_array,specbox_y_shift=specbox_y_shift
  
; Do sensitivity correction
  irc_senscalib,specimage_n_wc,mask_specimage_n,wave_array,source_table,specimage_n_fc,sigmaimage_n_fc
  make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d
  
  if keyword_set(no_show_ds9) EQ 0 then begin
     show_aperture_on_ds9,specimage_bg,source_table
     show_aperture_on_ds9,refimage_bg,source_table,/IMAG
  endif
  
  process_header,specheader,imagheader,source_table,specheader_extract,imagheader_extract

  logger->append,['---','All done.']
  
  write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                   refimage_bg,specimage_bg,refimage_n_bg,specimage_n_wc,specimage_n_fc, $
                   res_refimage_bg,res_specimage_bg, $
                   mask_refimage,mask_specimage,mask_specimage_n, $
                   imagheader,specheader,imagheader_extract,specheader_extract, $
                   noisemap,noisemap_n,noise_mask, $
                   dir=workdir
  
; Common plot param definitions here.
  !X.STYLE=1 & !Y.STYLE=17 & !P.PSYM=0 ; 1 (for exact range set) + 16 (/ynozero)
  source_id=0
 
  if keyword_set(no_message_finish) then stop
  message,'Finish'
  
; Plot spectra
plot_spec_with_image,wave_array,specimage_n_wc,mask_specimage_n,source_table,source_id;,offset_pix=0,/wc_mode,smooth_width=3,nsum=3

wave_offset=-1.
change_wave_offset,wave_offset,specimage_n_sff,source_table,specimage_n_wc,wave_array,specimage_bg

irc_edit_aperture_on_ds9,source_table,refimage_n_bg,specimage_n_wc,use_array

; Image QL
source_id=0
atv,specimage_n_fc[*,*,source_id],/block
atv,specimage_n_wc[*,*,source_id],/block
atv,specimage_n_wc[*,*,source_id]*mask_specimage_n[*,*,source_id],/block
atv,mask_specimage_n[*,*,source_id],/block

atv,refimage_bg,/block
atv,res_refimage_bg[*,*,1],/block
atv,mask_refimage,/block
atv,specimage_bg,/block
atv,res_specimage_bg[*,*,1],/block
atv,mask_specimage,/block

set_color

; Aperture QL
show_aperture_on_ds9,specimage_ff[*,*,1],source_table
show_aperture_on_ds9,specimage_bg,source_table
show_aperture_on_ds9,refimage_bg,source_table,/IMAG

;;; from disk

; show whole images on ds9
display_whole_images,targetid,targetsubid,ext_source_table,refimage_bg_filename,specimage_bg_filename,filter_spec, $
              root_dir=root_dir

;display_whole_images,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.refimage_bg.fits','5020033.1.N3_NP.specimage_bg.fits',"N3_NP",root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'

; show extracted images on ds9
display_extracted_images,targetid,targetsubid,ext_source_table,refimage_n_filename,specimage_n_filename,filter_spec, $
              root_dir=root_dir
;display_extracted_images,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.refimage_bg_indiv.fits','5020033.1.N3_NP.specimage_wc_indiv.fits',"N3_NP",root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'

; plot spec
display_spec,targetid,targetsubid,ext_source_table,specimage_n_wc_filename,mask_specimage_n_wc_filename,filter_spec,source_id, $
          root_dir=root_dir
;display_spec,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.specimage_wc_indiv.fits','5020033.1.N3_NP.specimage_mask_indiv.fits',"N3_NP",21,root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'

end
