pro plot_spec_with_errorbar,wave_array,specimage_n_wc,specmask_n,source_table,source_id, $
                            offset_pix=offset_pix,no_wavelength_shift_error=no_wavelength_shift_error, $
                            noise_plot_only=noise_plot_only, $
                            smooth_width=smooth_width,nsum_keyword=nsum_keyword,space_shift_keyword=space_shift_keyword, $
                            redshift=redshift,stdstar_mode=stdstar_mode,bgsub=bgsub,whole_aperture=whole_aperture, $
                            wc_mode=wc_mode,no_mask=no_mask,PS=PS,PNG=PNG,ASCII=ASCII,show_bg=show_bg, $
                            lambda_template=lambda_template,flux_template=flux_template,z_template=z_template, $
                            scale_template=scale_template,sigma_filter=sigma_filter,average_mode=average_mode, $
                            _EXTRA=EXTRA_KEYWORDS

common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
common measured_offsets,space_shift,nsum

if defined(specimage_n_wc) EQ 0 then begin
   print,'Warning (plot_spec_with_errorbar): input array (specimage_n_wc) is undefined!'
   return
end

; param check
s=size(specimage_n_wc) & if s[0] EQ 3 then n_source=s[3] else n_source=1
if source_id GT n_source-1 then begin
   print,'Warning (plot_spec_with_errorbar): invalid source_id!'
   return
end

set_color,/white_bg

y_shift=0.5                     ; statistical error of Y pos

if defined(PS) then begin
   pson, FILENAME=workdir+'/'+PS+'.ps',page_size='A4',/landscape
   print,'Writing on a PS file'
endif

if defined(source_id) EQ 0 then source_id=0
if defined(redshift) EQ 0 then redshift=0.
if defined(offset_pix) EQ 0 then offset_pix=0.
if defined(nsum_keyword) then nsum=nsum_keyword
if defined(space_shift_keyword) then space_shift=space_shift_keyword
if defined(specmask_n) EQ 0 then specmask_n=make_array(size(specimage_n_wc,/dimensions),/float,value=1.); make a dummy mask cube
if defined(whole_aperture) EQ 0 then whole_aperture=1
if keyword_set(sigma_filter) then begin
   specimage_n_wc_med=sigma_filter_cube(specimage_n_wc,1)
   median_width=1;2
endif else begin
   specimage_n_wc_med=specimage_n_wc
   median_width=1
endelse

if  NG() || LG2() then d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) $
else                   d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) ; negative LG2 diseprsion

;check response systematic error
shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id],wave_array_shift
irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc,   sigmaimage_n_fc,/no_logger_out

shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]+y_shift,wave_array_shift
irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc_p1,sigmaimage_n_tmp,/no_logger_out

shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]-y_shift,wave_array_shift
irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc_n1,sigmaimage_n_tmp,/no_logger_out

shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id],wave_array_shift

make_spec1d,specimage_n_wc_med,specimage_n_fc_p1,specmask_n,sigmaimage_n_fc,source_table, $
            specimage_wc_p1_1d,specimage_fc_p1_1d,sigmaimage_fc_1d_tmp, $
            no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
            noise_plot_only=noise_plot_only,average_mode=avearege_mode
make_spec1d,specimage_n_wc_med,specimage_n_fc_n1,specmask_n,sigmaimage_n_fc,source_table, $
            specimage_wc_n1_1d,specimage_fc_n1_1d,sigmaimage_fc_1d_tmp, $ 
            no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
            noise_plot_only=noise_plot_only,average_mode=avearege_mode
make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
            specimage_wc_0_1d,   specimage_fc_0_1d,   sigmaimage_fc_1d_tmp, $
            no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
            noise_plot_only=noise_plot_only,average_mode=avearege_mode
make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
            specimage_wc_1d,   specimage_fc_1d,   sigmaimage_fc_1d, $
            no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
            noise_plot_only=noise_plot_only,average_mode=avearege_mode

make_offspec_for_plot,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table,source_id, $
             off_specimage_wc_1d,off_specimage_fc_1d,nsum_bg, $
             bgsub=bgsub,no_mask=no_mask,stdstar_mode=stdstar_mode,/average_mode,whole_aperture=whole_aperture

calc_noise_for_plot,sigmaimage_fc_1d,specimage_fc_p1_1d,specimage_fc_n1_1d,specimage_fc_0_1d,source_table,source_id,nsum_bg, $
                    error_p_wc_total,error_n_wc_total,error_p_wc_total_bg,error_n_wc_total_bg, $
                    shift_error_p_fc,shift_error_n_fc,error_p_fc_total,error_n_fc_total, $
                    no_wavelength_shift_error=no_wavelength_shift_error

; calc error X corresponding to 1 pixel shift
shift_wavelength,wave_array_shift,1,wave_array_shift_1
d_wave_array=abs(wave_array_shift_1-wave_array_shift)

do_smooth_spec_for_plot,specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
                        specimage_wc_1d_smooth,specimage_fc_1d_smooth, $
                        error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
                        smooth_width=smooth_width,median_width=median_width

; Make pretty plots

if keyword_set(wc_mode) then begin
   plot,wave_array,specimage_wc_1d_smooth,ytitle='Count (ADU)',xtitle='Lambda (um)', $
        xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=10,color=white,_extra=extra_keywords
   err_plot,wave_array, specimage_wc_1d_smooth+error_n_wc_total,specimage_wc_1d_smooth-error_n_wc_total,color=red
   oplot,wave_array,fltarr(n_elements(wave_array)),linestyle=2,color=green
   if keyword_set(show_bg) then begin
      oplot,wave_array,off_specimage_wc_1d[*,source_id],color=yellow,psym=10
      err_plot,wave_array, $
               off_specimage_wc_1d[*,source_id]+error_n_wc_total_bg, $
               off_specimage_wc_1d[*,source_id]-error_n_wc_total_bg,color=yellow
   endif
   goto,finish
endif

if keyword_set(noise_plot_only) then begin ; if not in noise_plot_only mode, plot data.
   plot,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000., $
        ytitle='1-sigma noise-equivalent flux (mJy)',xtitle='Lambda (um)', $
        xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=6,color=white,_extra=extra_keywords,/nodata

; correction factor for AOT04c
;case (1) of
;   NP(): noise_fac=1./sqrt(2.)
;   NG(): noise_fac=1./sqrt(2.)
;   SG1(): noise_fac=1./sqrt(2.)
;   SG2(): noise_fac=1./sqrt(2.)
;   LG2(): noise_fac=1.
;endcase

   noise_fac=1.
   oplot,wave_array_shift,error_p_fc_total*1000.*noise_fac,color=white,psym=10
;  err_plot,wave_array_shift,-error_n_fc_total*1000.,error_p_fc_total*1000.,color=yellow
   oplot,wave_array_shift,shift_error_p_fc*1000.*noise_fac,color=blue,psym=10
;  err_plot,wave_array_shift,-shift_error_n_fc*1000.,shift_error_p_fc*1000.,color=green
   goto,finish
endif

!X.STYLE=1 & !Y.STYLE=17        ; 1 (for exact range set) + 16 (/ynozero)
   
if defined(stdstar_mode) then begin
   fileName = DIALOG_PICKFILE (PATH=calibdir+'StdSpecData/', FILTER = '*.tem',title='COHEN STD Stars')
   read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename
   ; Plot cohen template
   plot,cohen_lambda,cohen_flux*1000.,ytitle='Flux (mJy)',xtitle='Lambda (um)', $
        xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=0,color=white,_extra=extra_keywords
   ; re-plot cohen template with different psym
   oplot,cohen_lambda,cohen_flux*1000.,psym=4,color=white
   ; plot cohen template error
   err_plot,cohen_lambda,cohen_flux*1000.+cohen_d_flux*1000.,cohen_flux*1000.-cohen_d_flux*1000.,color=white,width=0
   ; plot observed spectrum
   oplot,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000.,psym=6,color=blue,_extra=extra_keywords
endif else begin
   ; plot observed spectrum
   plot,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000., $
        ytitle='Flux (mJy)',xtitle='Lambda (um)', $
        xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=6,color=white,_extra=extra_keywords
endelse

err_plot_XY,wave_array_shift/(1.+redshift), $
            specimage_fc_1d_smooth*1000., $
            specimage_fc_1d_smooth*1000.-error_n_fc_total*1000., $
            specimage_fc_1d_smooth*1000.+error_p_fc_total*1000., $
            wave_array_shift/(1.+redshift)-d_wave_array, $
            wave_array_shift/(1.+redshift)+d_wave_array, $
            color=red,width=0,psym=0

; overplot the result at the very end for clarity of the plot.
oplot,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000.,psym=6,color=blue,_extra=extra_keywords

; plot observed spectrum with histograms
oplot,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000.,psym=10,color=white

; plot baseline (flux=0)
oplot,wave_array_shift/(1.+redshift),fltarr(n_elements(wave_array)),linestyle=2,color=white

; overplot template spectra
if keyword_set(lambda_template) then begin
   redshift_spec,lambda_template,flux_template,z_template,scale_template,lambda_template_z,flux_template_z
   oplot,lambda_template_z,flux_template_z,color=blue
;  oplot,lambda_template,flux_template,color=blue,psym=10
endif

; plot background spectrum
if keyword_set(show_bg) then oplot,wave_array,off_specimage_fc_1d[*,source_id]*1000.,color=yellow,psym=10

finish:

oplot,[!IRC_SPECRED_SPECPARAM.w_cover_2[0],!IRC_SPECRED_SPECPARAM.w_cover_2[0]],[-1e6,1e6],color=green
oplot,[!IRC_SPECRED_SPECPARAM.w_cover_2[1],!IRC_SPECRED_SPECPARAM.w_cover_2[1]],[-1e6,1e6],color=green

if defined(PS) then psoff

if keyword_set(PNG) then begin
   print,'Writing a PNG file.'
   saveimage,workdir+'/'+PNG+'.png',/png
end

if keyword_set(ASCII) then begin
   print,'Writing an ASCII spectrum.'
   write_spec,wave_array_shift/(1.+redshift),specimage_fc_1d_smooth*1000., $
              specimage_fc_1d_smooth*1000.-error_n_fc_total*1000., $
              specimage_fc_1d_smooth*1000.+error_p_fc_total*1000., $
              filename=workdir+'/'+ASCII+'.spc'
; to plot the output with the gnuplot, type 'plot "ASCII.spc" with yerrorbars'
end

end
