pro plot_spec_with_image,wave_array,specimage_n_wc,specmask_n,source_table,source_id, $
                         smooth_width=smooth_width,nsum_keyword=nsum_keyword,space_shift_keyword=space_shift_keyword, $
                         no_mask=no_mask,$
; pre-filter
                         sigma_filter_set=sigma_filter_set, $
; maintenance option
                         offset_pix=offset_pix,average_mode=average_mode, $
; background process option
                         bg_show=bg_show,bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset, $
; stdstar mode
                         stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
; template overlay
                         lambda_template=lambda_template,flux_template=flux_template,z_template=z_template, $
                         scale_template=scale_template,redshift=redshift, $
; flux unit
                         watt=watt,wc_mode=wc_mode,diffuse=diffuse,lambda2=lambda2, $
; TV option
                         with_image=with_image,tvbottom=tvbottom,tvtop=tvtop,dir=dir, $
; noise plot
                         noise_plot_only=noise_plot_only,no_shotnoise=no_shotnoise,no_wavelength_shift_error=no_wavelength_shift_error, $
                         flux_error_plot=flux_error_plot, $
; output
                         PS=PS,PNG=PNG,ASCII=ASCII, $
                         wave_array_shift=wave_array_shift,error_p_fc_total=error_p_fc_total, $
                         specimage_wc_1d_smooth=specimage_wc_1d_smooth,specimage_fc_1d_smooth=specimage_fc_1d_smooth, $
; extra
                         _EXTRA=EXTRA_KEYWORDS

  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir
  common colors,black,magenta,cyan,yellow,green,red,blue,navy,aqua,orchid,sky,beige,charcoal,grey,white
  common measured_offsets,space_shift,nsum
  
; param check
  if defined(specimage_n_wc) EQ 0 then begin
     print,'Warning (plot_spec_with_image): input array (specimage_n_wc) is undefined!'
     return
  endif
  
  s=size(specimage_n_wc) & if s[0] EQ 3 then n_source=s[3] else n_source=1
  if source_id GT n_source-1 then begin
     print,'Warning (plot_spec_with_image): invalid source_id!'
     return
  endif
  
  specmask_n_org=specmask_n

  if keyword_set(no_mask) then $
     specmask_n=make_array(size(specimage_n_wc,/dimensions),/float,value=1.) $
  else $
     make_mask_n,source_table,specmask_n
  
  if (~ keyword_set(watt)) && (~ keyword_set(diffuse)) && (~ keyword_set(lambda2)) then mjy=1B
  
  if ~ defined(bg_nsum) then bg_nsum=1
  if ~ defined(bg_offset) then bg_offset=1
;  if defined(smooth_width) then begin
;     if smooth_width EQ 0 then smooth_width=1; width=1 means no smoothing
;  endif

  set_color,/white_bg
  margin=0.1
  x_winsize=29.7/2.54*72        ; 72 dpi for mac; was 800; 96 for windows
  y_winsize=21.0/2.54*72        ; was 600
  
  if !d.window EQ -1 then window,xsize=x_winsize,ysize=y_winsize
  
  if keyword_set(with_image) then begin
     !p.position=[margin,0.5+margin,1.0-margin,1.0-margin]
;  !x.margin=[0,0] & !y.margin=[0,0]
  endif else begin
     !p.position=0
  endelse
  
  y_shift=1.0                   ; statistical error of Y pos; was 0.5
  
  if defined(PS) then begin
     pson, FILENAME=workdir+'/'+PS+'.ps',/landscape,paper='A4',margin=0.
     print,'Writing on a PS file'
  endif
  
  if defined(source_id) EQ 0 then source_id=0
  if defined(redshift) EQ 0 then redshift=0.
  if defined(offset_pix) EQ 0 then offset_pix=0.
  if defined(nsum_keyword) then nsum=nsum_keyword
  if defined(space_shift_keyword) then space_shift=space_shift_keyword
  if defined(specmask_n) EQ 0 then specmask_n=make_array(size(specimage_n_wc,/dimensions),/float,value=1.) ; make a dummy mask cube
  if defined(whole_aperture) EQ 0 then whole_aperture=1
  if keyword_set(sigma_filter_set) then begin
     specimage_n_wc_med=sigma_filter_cube(specimage_n_wc,3)
     median_width=1
  endif else begin
     specimage_n_wc_med=specimage_n_wc
     median_width=1
  endelse
  if keyword_set(tvtop) EQ 0 then tvtop=100
  if keyword_set(tvbottom) EQ 0 then tvbottom=0
  
  if  NG() || LG2() then d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) $
  else                   d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) ; negative LG2 diseprsion
  
;check response systematic error
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]        ,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc,   sigmaimage_n_fc, $
                /no_logger_out,no_shotnoise=no_shotnoise

  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]+y_shift,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc_p1,sigmaimage_n_tmp, $
                /no_logger_out,no_shotnoise=no_shotnoise
  
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]-y_shift,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specmask_n,wave_array_shift,source_table,specimage_n_fc_n1,sigmaimage_n_tmp, $
                /no_logger_out,no_shotnoise=no_shotnoise
  
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id],wave_array_shift
  
  make_spec1d,specimage_n_wc_med,specimage_n_fc_p1,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_p1_1d,specimage_fc_p1_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode
  make_spec1d,specimage_n_wc_med,specimage_n_fc_n1,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_n1_1d,specimage_fc_n1_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode
  make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_0_1d,specimage_fc_0_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode
  make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode
  
  make_offspec_for_plot,specimage_n_wc_med,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table,source_id, $
                        off_specimage_wc_1d,off_specimage_fc_1d, $
                        bg_nsum=bg_nsum,bg_sub=bg_sub,bg_offset=bg_offset,no_mask=no_mask,average_mode=average_mode, $
                        stdstar_mode=stdstar_mode,whole_aperture=whole_aperture

  calc_noise_for_plot,sigmaimage_fc_1d,specimage_fc_p1_1d,specimage_fc_n1_1d,specimage_fc_0_1d,source_table,source_id,bg_nsum, $
                      error_p_wc_total,error_n_wc_total,error_p_wc_total_bg,error_n_wc_total_bg, $
                      shift_error_p_fc,shift_error_n_fc,error_p_fc_total,error_n_fc_total, $
                      no_wavelength_shift_error=no_wavelength_shift_error

; calc error X corresponding to y_shift pixel shift
  shift_wavelength,wave_array_shift,y_shift,wave_array_shift_1
  d_wave_array=abs(wave_array_shift_1-wave_array_shift)
  
  do_smooth_spec_for_plot,specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
                          specimage_wc_1d_smooth,specimage_fc_1d_smooth, $
                          error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
                          smooth_width=smooth_width,median_width=median_width,bg_sub=bg_sub
  
; Make pretty plots
  
  !X.STYLE=1 & !Y.STYLE=17      ; 1 (for exact range set) + 16 (/ynozero)
  
  case 1 of
     (keyword_set(wc_mode)): begin
        if keyword_set(with_image) then $
           plot_spec,wave_array,specimage_wc_1d_smooth,psym=10,color=white,/wc,_extra=extra_keywords, $
                     xrange=[wave_array_shift[0],wave_array_shift[n_elements(wave_array_shift)-1]] $
        else $
           plot_spec,wave_array,specimage_wc_1d_smooth, $
                     xrange=!IRC_SPECRED_SPECPARAM.w_cover,psym=10,color=white,_extra=extra_keywords
        
        plot_spec,wave_array,specimage_wc_1d_smooth+error_n_wc_total,specimage_wc_1d_smooth-error_n_wc_total,color=red,/errory
        plot_spec,wave_array,fltarr(n_elements(wave_array)),linestyle=2,color=green,_extra=extra_keywords,/oplot
        if keyword_set(bg_show) then begin
           oplot,wave_array,off_specimage_wc_1d[*,source_id],color=yellow,psym=10,_extra=extra_keywords
           plot_spec,wave_array, off_specimage_wc_1d[*,source_id]+error_n_wc_total_bg, $
                     off_specimage_wc_1d[*,source_id]-error_n_wc_total_bg,color=yellow,/errory
        endif
     end
     
     (keyword_set(noise_plot_only)): begin
; correction factor for AOT04c
;case (1) of
;   NP(): noise_fac=1./sqrt(2.)
;   NG(): noise_fac=1./sqrt(2.)
;   SG1(): noise_fac=1./sqrt(2.)
;   SG2(): noise_fac=1./sqrt(2.)
;   LG2(): noise_fac=1.
;endcase
        noise_fac=1.
        plot_spec,wave_array_shift,error_p_fc_total*noise_fac,color=white,psym=10,_extra=extra_keywords,mjy=mjy,watt=watt,lambda2=lambda2, $
                  ytitle='1-sigma noise-equivalent flux (mJy)',with_image=with_image
        plot_spec,wave_array_shift,shift_error_p_fc*noise_fac, $
                  color=blue,psym=10,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2
     end
     
     else: begin
        if ~ defined(stdstar_mode) then begin
           test=findgen(n_elements(wave_array_shift))
           test=(test-(n_elements(wave_array_shift)-1)/2.)*(-0.171)+23.504
           test=wave_array_shift
           plot_spec_obs,test,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                         redshift=redshift,mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2,_extra=extra_keywords,with_image=with_image 
        endif else begin
           fileName = DIALOG_PICKFILE (PATH=calibdir+'StdSpecData/', FILTER = '*.tem',title='COHEN STD Stars')
           read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename
           if keyword_set(flux_error_plot) then begin
              bin_cohen_spec,cohen_lambda,cohen_flux,cohen_d_flux,wave_array,cohen_flux_bin,cohne_d_flux_bin
              !P.multi=[0,0,2]
              plot_spec,wave_array_shift,abs(specimage_fc_1d_smooth-cohen_flux_bin)/cohen_flux_bin*100., $; systematic error
                        color=white,psym=10,ytitle='fractional error (%)',yr=[0,50],xrange=!IRC_SPECRED_SPECPARAM.w_cover
              plot_spec,wave_array_shift,error_p_fc_total/cohen_flux_bin*100.,psym=10,color=red,/oplot; S/N plot
              
              
              plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                            redshift=redshift,mjy=mjy,watt=watt,lambda2=lambda2,_extra=extra_keywords
              plot_spec_cohen,cohen_lambda,cohen_flux,cohen_d_flux,wave_array_shift, $
                              with_image=with_image,mJy=mjy,watt=watt,lambda2=lambda2,_extra=extra_keywords
              
              !P.multi=0
           endif else begin
              plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                            redshift=redshift,mjy=mjy,watt=watt,lambda2=lambda2,_extra=extra_keywords,with_image=with_image
              plot_spec_cohen,cohen_lambda,cohen_flux,cohen_d_flux,wave_array_shift, $
                              with_image=with_image,mJy=mjy,watt=watt,lambda2=lambda2,_extra=extra_keywords
           endelse
           
        endelse
        
; overplot template spectra
        if keyword_set(lambda_template) then begin
           redshift_spec,lambda_template,flux_template,z_template,scale_template,lambda_template_z,flux_template_z
           plot_spec,lambda_template_z,flux_template_z,color=blue,/oplot,mjy=mjy,watt=watt,lambda2=lambda2
;          oplot,lambda_template,flux_template,color=blue,psym=10
        endif
        
; plot background spectrum
        if keyword_set(bg_show) then $
           plot_spec,wave_array,off_specimage_fc_1d[*,source_id], $
                     color=green,psym=10,_extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2
        
     end
  endcase
  
; plot X range for reliable range
  if (!Y.range[0] EQ 0D && !Y.range[1] EQ 0D) then begin
     tmp=where(specimage_fc_1d_smooth GT 0.,count)
     if count GT 0 then y_vertical_range_min=min(specimage_fc_1d[tmp])*1000. $
     else               y_vertical_range_min=min(specimage_fc_1d_smooth)*1000.
     y_vertical_range=[y_vertical_range_min,max(specimage_fc_1d_smooth*1000.)]
  endif else $
     Y_vertical_range=!Y.RANGE
  
  oplot,[!IRC_SPECRED_SPECPARAM.w_cover_2[0],!IRC_SPECRED_SPECPARAM.w_cover_2[0]],Y_vertical_range, $
        color=green,_extra=extra_keywords
  oplot,[!IRC_SPECRED_SPECPARAM.w_cover_2[1],!IRC_SPECRED_SPECPARAM.w_cover_2[1]],Y_vertical_range, $
        color=green,_extra=extra_keywords ; was [-1e6,1e6]
  
; display image nicely
  if keyword_set(with_image) then begin
     draw_tv,specimage_n_wc,specmask_n,wave_array_shift,source_id, $
             smooth_width=smooth_width,tvtop=tvtop,tvbottom=tvbottom,margin=margin,x_winsize=x_winsize,y_winsize=y_winsize,ps=ps, $
             bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset
  endif else begin
     !p.position=0
  endelse

; output ASCII dump file
  
  if keyword_set(ASCII) then begin
     print,'Writing an ASCII spectrum.'
     if defined(dir) then dir=expand_path(dir) else dir=workdir

     if keyword_set(noise_plot_only) then $
        write_spec,wave_array_shift,error_p_fc_total*noise_fac, $
                   filename=dir+'/'+ASCII+'.spc',watt=watt,mjy=mjy,lambda2=lambda2,redshift=redshift $
     else $
        write_spec,wave_array_shift,specimage_fc_1d_smooth,specimage_fc_1d_smooth-error_n_fc_total,specimage_fc_1d_smooth+error_p_fc_total, $
                   filename=dir+'/'+ASCII+'.spc',watt=watt,mjy=mjy,lambda2=lambda2,redshift=redshift
; to plot the output with the gnuplot, type 'plot "ASCII.spc" with yerrorbars'
  endif
  
  if defined(PS) then psoff
  
  if keyword_set(PNG) then begin
     print,'Writing a PNG file.'
     saveimage,workdir+'/'+PNG+'.png',/png
  endif
  
  !p.position=0
  
  specmask_n=specmask_n_org

end
