pro show_aperture_on_ds9,image,source_table, $
                         IMAG=IMAG,median=median,sigma_filter_set=sigma_filter_set,header=header

  common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

  user='_FOR_'+strupcase(getenv('USER'))

; Check if ds9 is already up...
  spawn,'xpaaccess -n IRC_SPECRED'+user,result

; if ds9 is not ready, launch the new one.
  if fix(result) EQ 0 then spawn,'ds9 -title IRC_SPECRED'+user+' -scale mode zscale -tile yes &'

; wait till ds9 is up and ready
  repeat begin
     wait,1
     spawn,'xpaaccess -n IRC_SPECRED'+user,result
  endrep until fix(result) EQ 1

  spawn,'xpaset -p IRC_SPECRED'+user+' regions format ds9'
  
; re-set DS9 frame size nicely.
  s=size(image) & dim=s[0]
  if NIR() then fac=1 else fac=2
  spawn,'xpaget IRC_SPECRED'+user+' height',result
  if float(result[0]) NE s[2]*fac then begin
     spawn,'xpaset -p IRC_SPECRED'+user+' height '+strcompress(string(s[2]*fac)  ,/remove) + $
         '; xpaset -p IRC_SPECRED'+user+' width ' +strcompress(string(s[1]*fac*2),/remove)
  endif
  
; display image on 2nd frame
  if keyword_set(IMAG) then begin
; check # of frames
     spawn,'xpaget IRC_SPECRED'+user+' frame active',result
; when only 1 frame is active, launch the 2nd one.
     if strlen(result) EQ 2 then spawn,'xpaset -p IRC_SPECRED'+user+' frame new'
     spawn,'xpaset -p IRC_SPECRED'+user+' frame 2' 
  endif else spawn,'xpaset -p IRC_SPECRED'+user+' frame 1'
  
  if NIR() then spawn,'xpaset -p IRC_SPECRED'+user+' zoom to 1' $
  else          spawn,'xpaset -p IRC_SPECRED'+user+' zoom to 2'
  
  filename=tmpdir+'/show_aperture_on_ds9_tmp.fits'
  file_delete,filename,/allow_nonexistent

  case 1 of
     (keyword_set(IMAG) && NIR()): mwrfits,sigma_filter_cube(image,1),filename,header,/silent
     (keyword_set(median)): mwrfits,medcube(image,2),filename,header,/silent
     (keyword_set(sigma_filter_set)): mwrfits,sigma_filter_cube(image,1),filename,header,/silent
     (keyword_set(IMAG) && LG2()): mwrfits,image,filename,header,/silent; was medcube(,2)
     else: mwrfits,image,filename,header,/silent
  endcase

  spawn,'xpaset -p IRC_SPECRED'+user+' file '+filename
  if dim EQ 3 then begin
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        spawn,'xpaset -p IRC_SPECRED'+user+' datacube 1' $ ; set datacube for long
     else $
        spawn,'xpaset -p IRC_SPECRED'+user+' datacube 2' ; set datacube for long
  endif

  if defined(source_table) then begin
     regionfilename=tmpdir+'/show_aperture_on_ds9_tmp.reg'
     file_delete,regionfilename,/allow_nonexistent
     if keyword_set(IMAG) then write_ds9_region_file,source_table,filename=regionfilename,/IMAG $
     else                      write_ds9_region_file,source_table,filename=regionfilename
     spawn,'xpaset -p IRC_SPECRED'+user+' regions load '+regionfilename
  endif
  
end
