pro calc_mir_refimage_shift,inimage,n_frame,dx,dy

  common GUI,logger

  logger->append,['  measuring offsets among subframes.']

  irc_calcsky_mmm,inimage[*,*,0],skymod,noise
  FWHM=!IRC_SPECRED_SOURCEDETECTPARAM.fwhm_for_find
  
find_retry:
  find_nan,sigma_filter( $
           inimage[!IRC_SPECRED_AREAINFO.sky_x1:!IRC_SPECRED_AREAINFO.sky_x2, $
                   !IRC_SPECRED_AREAINFO.sky_y1:!IRC_SPECRED_AREAINFO.sky_y2,0],radius=1,/ite,/all $
                       ), x0,y0,flux0,sharp,roundness, !IRC_SPECRED_SOURCEDETECTPARAM.sigma*noise, $
           fwhm,!IRC_SPECRED_SOURCEDETECTPARAM.round,!IRC_SPECRED_SOURCEDETECTPARAM.sharp,/silent
  find_nan,sigma_filter( $
           inimage[!IRC_SPECRED_AREAINFO.sky_x1:!IRC_SPECRED_AREAINFO.sky_x2, $
                   !IRC_SPECRED_AREAINFO.sky_y1:!IRC_SPECRED_AREAINFO.sky_y2,1],radius=1,/ite,/all $
                       ),x1,y1,flux1,sharp,roundness, !IRC_SPECRED_SOURCEDETECTPARAM.sigma*noise, $
           fwhm,!IRC_SPECRED_SOURCEDETECTPARAM.round,!IRC_SPECRED_SOURCEDETECTPARAM.sharp,/silent
  find_nan,sigma_filter( $
           inimage[!IRC_SPECRED_AREAINFO.sky_x1:!IRC_SPECRED_AREAINFO.sky_x2, $
                   !IRC_SPECRED_AREAINFO.sky_y1:!IRC_SPECRED_AREAINFO.sky_y2,2],radius=1,/ite,/all $
                       ), x2,y2,flux2,sharp,roundness, !IRC_SPECRED_SOURCEDETECTPARAM.sigma*noise, $
           fwhm,!IRC_SPECRED_SOURCEDETECTPARAM.round,!IRC_SPECRED_SOURCEDETECTPARAM.sharp,/silent
  
  if (~ defined(x0)) || total(x0) EQ 0. || (~ defined(x1)) || total(x1) EQ 0. || (~ defined(x2)) || total(x2) EQ 0. then begin
     print,'Information (calc_mir_refimage_shift): No sources were detected! Change detection threshold and retry.'
     noise*=2./3.
     goto,find_retry
  endif
  
  n_max=500
  dx01=fltarr(n_max) & dy01=fltarr(n_max)
  weight01=fltarr(n_max) & weight12=fltarr(n_max)
  dx12=fltarr(n_max) & dy12=fltarr(n_max)
  
  k=0
  for i=0,n_elements(x0)-1 do begin
     for j=0,n_elements(x1)-1 do begin
        d=((x0[i]-x1[j])^2.+(y0[i]-y1[j])^2.)^0.5
        if d LT 3. then begin
           dx01[k]=x0[i]-x1[j] & dy01[k]=y0[i]-y1[j] & weight01[k]=1./d
           k+=1
        endif
     endfor
  endfor
  
;  if k EQ 0 then message,'Error (calc_mir_refimage_shift): no common sources were detected... Stop!'
  if k EQ 0 then begin
     print,'Warning (calc_mir_refimage_shift): no common sources were detected... assuming  zero shift!'
     dx[1]=0. & dy[1]=0. & dx[2]=0. & dy[2]=0.
     return
  endif

  dx01=dx01[0:k-1]
  dy01=dy01[0:k-1]
  weight01=weight01[0:k-1]
  dx[1]=-w_mean(dx01,weight01) & dy[1]=-w_mean(dy01,weight01)
  
  k=0
  for i=0,n_elements(x1)-1 do begin
     for j=0,n_elements(x2)-1 do begin
        d=((x1[i]-x2[j])^2.+(y1[i]-y2[j])^2.)^0.5
        if d LT 3. then begin
           dx12[k]=x1[i]-x2[j] & dy12[k]=y1[i]-y2[j] & weight12[k]=1./d
           k+=1
        endif
     endfor
  endfor
  
;  if k EQ 0 then message,'Error (calc_mir_refimage_shift): no common sources were detected... Stop!'
  if k EQ 0 then begin
     print,'Warning (calc_mir_refimage_shift): no common sources were detected... assuming  zero shift!'
     dx[1]=0. & dy[1]=0. & dx[2]=0. & dy[2]=0.
     return
  endif
  
  dx12=dx12[0:k-1]
  dy12=dy12[0:k-1]
  weight12=weight12[0:k-1]
  dx[2]=-w_mean(dx12,weight12) & dy[2]=-w_mean(dy12,weight12)

; print,'mean MIR refimage shift in pix',mean(dx-dx[1]),mean(dy-dy[1])
  
end
