pro calc_short_long_offset,inimage_short,inimage_long,dx,dy

  inimage_short_sigma=sigma_filter( $
                      inimage_short[!IRC_SPECRED_AREAINFO.cor_x1:!IRC_SPECRED_AREAINFO.cor_x2, $
                                    !IRC_SPECRED_AREAINFO.cor_y1:!IRC_SPECRED_AREAINFO.cor_y2], $
                      radius=1,/iterate,/all)

  rms_short=robust_sigma_mod(inimage_short_sigma)
  
  inimage_long_sigma=sigma_filter( $
                     inimage_long[!IRC_SPECRED_AREAINFO.cor_x1:!IRC_SPECRED_AREAINFO.cor_x2, $
                                  !IRC_SPECRED_AREAINFO.cor_y1:!IRC_SPECRED_AREAINFO.cor_y2], $
                     radius=1,/iterate,/all)
  
  rms_long=robust_sigma_mod(inimage_long_sigma)

  cor_image=correl_images_mod(inimage_short_sigma > (5.*rms_short),inimage_long_sigma > (5.*rms_long), $
                              xshift=!IRC_SPECRED_COMBINEPARAM.x_cor_box_size, $
                              yshift=!IRC_SPECRED_COMBINEPARAM.y_cor_box_size)
  s=size(cor_image) & xsize=s[1]
  offset=where(cor_image EQ max(cor_image)) & offset=offset[0] ; to make sure that offset is not a vector.
  offset_y=fix(offset/xsize) & offset_x=offset-offset_y*xsize
  dx=offset_x-!IRC_SPECRED_COMBINEPARAM.x_cor_box_size
  dy=offset_y-!IRC_SPECRED_COMBINEPARAM.y_cor_box_size
  result=mpfit2dpeak_nan(cor_image,A,/tilt,errmsg=errmsg,/positive)

  dx=A[4]-!IRC_SPECRED_COMBINEPARAM.x_cor_box_size & dy=A[5]-!IRC_SPECRED_COMBINEPARAM.y_cor_box_size
  if A[1] LT 0.1 || abs(dx) GT 3. || abs(dy) GT 3. then begin
     print,'Warning (calc_short_long_offset): failed to find good shift values... assuming zero shift!'
     dx=0. & dy=0.
     return
  endif

  if A[1] LT 0.6 then $
     print,'Warning (calc_short_long_offset): cross-correlation peak is weak, '+strim(A[1])+', suggesting possible poor alignment!'
 
  if offset_x EQ !IRC_SPECRED_AREAINFO.cor_x2-!IRC_SPECRED_AREAINFO.cor_x1-1 || offset_x EQ 0 then $
     print,'Warning (calc_short_long_offset): Offset search box is too small (X)!'
  if offset_y EQ !IRC_SPECRED_AREAINFO.cor_y2-!IRC_SPECRED_AREAINFO.cor_y1-1 || offset_y EQ 0 then $
     print,'Warning (calc_short_long_offset): Offset search box is too small (Y)!'
  
end
