pro calc_specbox_pos,source_table

; Set spec positions... considering imag->spec scale change

  case 1 of
     (NP()): begin
        source_table.spec_x=source_table.image_x*1.005+!IRC_SPECRED_SPECEXTRACTPARAM.x_offset ; was 1.0147
        source_table.spec_y=source_table.image_y+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset ; was 1.0147
     end
     (SG1()): begin
        source_table.spec_x=source_table.image_x/1.005+!IRC_SPECRED_SPECEXTRACTPARAM.x_offset ; was /1.005
        source_table.spec_y=source_table.image_y+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset ; was 1.0147
     end
     (LG2()): begin
        source_table.spec_x=source_table.image_x/1.025+!IRC_SPECRED_SPECEXTRACTPARAM.x_offset ; was 1.0147
        source_table.spec_y=source_table.image_y/1.025+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset ; was 1.0147
     end
     else: begin
        source_table.spec_x=source_table.image_x+!IRC_SPECRED_SPECEXTRACTPARAM.x_offset
        source_table.spec_y=source_table.image_y+!IRC_SPECRED_SPECEXTRACTPARAM.y_offset
     end
  endcase
  
; Apply NP distortion correction
  if NP() && (!IRC_SPECRED_OBSPARAM.preflight_mode EQ 0B) && (!IRC_SPECRED_PROCESSOPTION.no_NP_distortion_mode EQ 0B) then $
     apply_np_spec_distortion,source_table
  
  if finite(source_table[0].image_FWHM) then begin
     source_table.spec_mask_dx=fix(source_table.image_FWHM*!IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_fac) $
                               > !IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_min $
                               < !IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_max
     source_table.image_mask_dx=source_table.spec_mask_dx
     source_table.image_mask_dy=source_table.spec_mask_dx
  endif
  
; other default settings
  source_table[*].spec_x_FWHM=0.
  source_table[*].spec_x_pos=(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
; if NG() then source_table[*].spec_x_pos-=2 ; this cancels X shift of NG spec rotation
  
; for maintenance
  
  if !IRC_SPECRED_OBSPARAM.preflight_mode then begin
     source_table[*].spec_mask_dx=3
     case 1 of
        (NG()) : source_table[*].spec_x+=3
        (SG2()): source_table[*].spec_x+=1
        (SG1()): source_table[*].spec_x-=1
        else:                   ; do nothing
     endcase
  endif
  
end
