pro check_image_for_find,image_cut_skysub,x,y,fwhm,use_array

  s=size(image_cut_skysub) & xsize=s[1] & ysize=s[2]
  n_source=n_elements(x)
  use_array=intarr(n_source)
  check_image_size=5
  x_round=round(x) & y_round=round(y)
  
  k=0
  for source_id=0,n_source-1 do begin
     if finite(x[source_id],/NAN) || finite(y[source_id],/NAN) then continue
     box_half_size_x=min([xsize-x[source_id],!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dx,x[source_id]-0])
     box_half_size_y=min([ysize-y[source_id],!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dy,y[source_id]-0])
     box_half_size=round(min([box_half_size_x,box_half_size_y]))
     check_image=image_cut_skysub[x_round[source_id]-box_half_size>0<(xsize-1): $
                                  x_round[source_id]+box_half_size>0<(xsize-1), $
                                  y_round[source_id]-box_half_size>0<(ysize-1): $
                                  y_round[source_id]+box_half_size>0<(ysize-1)]
     s=size(check_image)
     if s[1] LT 3 || s[2] LT 3 then begin
        print,'Warning (check_image_for_find): source '+strim(source_id)+' has too small area!, box_half_size = '+ $
              strim(box_half_size_x)+','+strim(box_half_size_y)+','+strim(box_half_size)
        continue
     endif
;  test=where(finite(check_image,/NAN),count)
;  print,source_id,count
;  if count GT 0 then continue
     use_array[k]=source_id
     k=k+1
  endfor

  if k EQ 0 then begin
     use_array=-1
     print,'Warning (check_image_for_find): all the data were flagged out!'
     return
  endif else begin
     use_array=use_array[0:k-1]
     meanclip_mod,fwhm[use_array],avg,sigma,sub=sub,clipsig=3 ; remove sources with outlier FWHM
     use_array=sub
  endelse
  
end
