pro display_spec_image,targetid,targetsubid,ext_source_table,specimage_n_wc_filename,mask_specimage_n_wc_filename,filter_spec,source_id, $
              root_dir=root_dir, $
              offset_pix=offset_pix,no_wavelength_shift_error=no_wavelength_shift_error, $
              noise_plot_only=noise_plot_only, $
              smooth_width=smooth_width,nsum_keyword=nsum_keyword,space_shift_keyword=space_shift_keyword, $
              redshift=redshift,stdstar_mode=stdstar_mode,bgsub=bgsub,whole_aperture=whole_aperture, $
              wc_mode=wc_mode,no_mask=no_mask,PS=PS,PNG=PNG,ASCII=ASCII,show_bg=show_bg, $
              lambda_template=lambda_template,flux_template=flux_template,z_template=z_template, $
              scale_template=scale_template,_EXTRA=EXTRA_KEYWORDS,median=median

common measured_offsets,space_shift,nsum
common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

make_env_var                    ; make environment variables
do_param_initialize,filter_spec,targetid,targetsubid,root_dir=root_dir,/no_logger_init,reference_fits=specimage_n_wc_filename,/file_in_workdir

read_source_table,source_table,ext_source_table=workdir+'/'+ext_source_table

; read fits
mask_specimage_n= MRDFITS(workdir+'/'+mask_specimage_n_wc_filename, 0, specheader, /silent)
specimage_n_wc= MRDFITS(workdir+'/'+specimage_n_wc_filename, 0, specheader, /silent)

; Create wavelength array
; set wave_offset_pix
;!IRC_SPECRED_PROCESSOPTION.shift_from_file=1B
;preset_wave_offset_pix,dir=workdir
!IRC_SPECRED_SPECPARAM.wave_offset_pix=float(fxpar(specheader,'W_OFFSET'))

wave_array=get_wavelength()

plot_spec_with_image,wave_array,specimage_n_wc,mask_specimage_n,source_table,source_id, $
                        offset_pix=offset_pix,no_wavelength_shift_error=no_wavelength_shift_error, $
                        noise_plot_only=noise_plot_only, $
                        smooth_width=smooth_width,nsum_keyword=nsum_keyword,space_shift_keyword=space_shift_keyword, $
                        redshift=redshift,stdstar_mode=stdstar_mode,bgsub=bgsub,whole_aperture=whole_aperture, $
                        wc_mode=wc_mode,no_mask=no_mask,PS=PS,PNG=PNG,ASCII=ASCII,show_bg=show_bg, $
                        lambda_template=lambda_template,flux_template=flux_template,z_template=z_template, $
                        scale_template=scale_template,_EXTRA=EXTRA_KEYWORDS,median=median

; Example
; display_spec,5020056,5,'5020056_5_S9W_SG1_target_table.tbl','5020056.5.S9W_SG1.specimage_wc_indiv.fits','5020056.5.S9W_SG1.specimage_mask_indiv.fits','S9W_SG1',1,root_dir='/home/ohyama/hd1.cava/IRC/PV/SPEC/OBJ/SPICY/0'

; display_spec,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.specimage_wc_indiv.fits','5020033.1.N3_NP.specimage_mask_indiv.fits','N3_NP',21,root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'

end
