pro display_whole_images,targetid,targetsubid,ext_source_table,refimage_bg_filename,specimage_bg_filename,filter_spec, $
              root_dir=root_dir

common measured_offsets,space_shift,nsum
common dir_structure,datadir,calibdir,datadir2,tmpdir,workdir

make_env_var; make environment variables
do_param_initialize,filter_spec,targetid,targetsubid,root_dir=root_dir,/no_logger_init,reference_fits=refimage_bg_filename,/file_in_workdir

read_source_table,source_table,ext_source_table=workdir+'/'+ext_source_table

; read fits
refimage_bg= MRDFITS(workdir+'/'+refimage_bg_filename, 0, imagheader, /silent)
specimage_bg= MRDFITS(workdir+'/'+specimage_bg_filename, 0, specheader, /silent)

!IRC_SPECRED_SPECPARAM.wave_offset_pix=float(fxpar(specheader,'W_OFFSET'))

show_aperture_on_ds9,specimage_bg,source_table
show_aperture_on_ds9,refimage_bg,source_table,/IMAG

; Example
;display_whole_images,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.refimage_bg.fits','5020033.1.N3_NP.specimage_bg.fits','N3_NP',root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'

end
