pro do_smooth_spec_for_plot,specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
                            specimage_wc_1d_smooth,specimage_fc_1d_smooth, $
                            error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
                            smooth_width=smooth_width,median_width=median_width,bg_sub=bg_sub
  
  if ~ defined(smooth_width) then smooth_width_tmp=1 else smooth_width_tmp=smooth_width; width=1 means no smoothing.
  if ~ defined(median_width) then median_width_tmp=1 else median_width_tmp=median_width; width=1 means no median smoothing.
  
  if smooth_width_tmp GE 2 then begin
     if keyword_set(bg_sub) then begin
        specimage_fc_1d_smooth=smooth(specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id],smooth_width_tmp)
        specimage_wc_1d_smooth=smooth(specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id],smooth_width_tmp)
     endif else begin
        specimage_fc_1d_smooth=smooth(specimage_fc_1d[*,source_id],smooth_width_tmp)
        specimage_wc_1d_smooth=smooth(specimage_wc_1d[*,source_id],smooth_width_tmp)
     endelse
     
;   robust_boxcar,wave_array_shift,specimage_fc_1d[*,source_id],smooth_width,wave_array_shift_smooth,specimage_fc_1d_smooth
;   specimage_fc_1d_smooth*=1000.
     
;   robust_boxcar,wave_array_shift,error_n_fc_total,smooth_width,wave_array_shift_smooth,error_n_fc_total_smooth
;   robust_boxcar,wave_array_shift,error_p_fc_total,smooth_width,wave_array_shift_smooth,error_p_fc_total_smooth
  endif else begin
     if keyword_set(bg_sub) then begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id]
     endif else begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]
     endelse

;    wave_array_shift_smooth=wave_array_shift
;    error_n_fc_total_smooth=error_n_fc_total
;    error_p_fc_total_smooth=error_p_fc_total
  endelse
  
; reducing error signal according to smooth length
  error_n_fc_total/=(sqrt(smooth_width_tmp*median_width_tmp))    & error_p_fc_total/=(sqrt(smooth_width_tmp*median_width_tmp))
  error_n_wc_total/=(sqrt(smooth_width_tmp*median_width_tmp))    & error_p_wc_total/=(sqrt(smooth_width_tmp*median_width))
  error_n_wc_total_bg/=(sqrt(smooth_width_tmp*median_width_tmp)) & error_p_wc_total_bg/=(sqrt(smooth_width_tmp*median_width_tmp))
  
end
