pro ds9_init,n_source,xgrid=xgrid,ygrid=ygrid,title=title

  if ~ defined(title) then title='IRC_SPECRED'
  if ~ defined(xgrid) then xgrid=25
  if ~ defined(ygrid) then ygrid=4

  spawn,'xpaaccess -n '+title,result
  if fix(result) EQ 0 then begin
    
     command='ds9 -title '+title+' -tile grid mode manual -tile grid layout '+string(xgrid)+' '+string(ygrid)+' -tile grid gap 1 -tile yes -scale mode zscale -view panner no'
     for frame=1,n_source do command=command+' -frame '+string(frame)
     command=command+' &'
     spawn,command
     repeat begin
        wait,1
        spawn,'xpaaccess -n '+title,result
     endrep until fix(result) EQ 1
   endif else begin
     spawn,'xpaset -p '+title+' tile grid mode manual'
     spawn,'xpaset -p '+title+' tile grid layout '+string(xgrid)+' '+string(ygrid)
     spawn,'xpaset -p '+title+' frame delete all'
  endelse
  
  spawn,'xpaset -p '+title+' regions format pros; xpaset -p '+title+' frame 1'
  
end
