pro ds9_make_fits_files,image3d,specimage3d

  common dir_structure,datadir,calibdir,datadir2,tmpdir

  s=size(image3d)
  if s[0] EQ 2 then n_source=1 else n_source=s[3]
 
  for i=0,n_source-1 do begin
     if n_source GT 1 then begin ; the case of 3D image
;   quick skysub for display purpose
;        skymod=median(image3d[*,*,i])
;        image3d_bg=image3d[*,*,i]-skymod
        image3d_bg=image3d[*,*,i]
;        skymod=median(specimage3d[*,*,i])
;        specimage3d_bg=specimage3d[*,*,i]-skymod
        specimage3d_bg=specimage3d[*,*,i]
     endif else begin           ; the case of 2D
;        skymod=median(image3d[*,*])
;        image3d_bg=image3d[*,*]-skymod
        image3d_bg=image3d[*,*]
;        skymod=median(specimage3d[*,*])
;        specimage3d_bg=specimage3d[*,*]-skymod
        specimage3d_bg=specimage3d[*,*]
     endelse
     
     disp_image=[[image3d_bg/10.],[specimage3d_bg]]
;   atv,disp_image,[specimage3d_bg]],/block
     
     filename=strcompress(tmpdir+'/tmp.'+string(i)+'.fits',/remove_all)
     file_delete,filename,/allow_nonexistent
     mwrfits,disp_image,filename,/silent
  endfor
  
end
