pro ds9_make_region_files,source_table,dx,dy,use_array,regionfilename0=regionfilename0

n_source=n_elements(source_table)

for frame=1,n_source do begin; frame counts from one, not zero! in ds9.
    regionfilename=strcompress(regionfilename0+string(frame)+'.reg',/remove_all)
    file_delete,regionfilename,/allow_nonexistent
    select=where(frame EQ use_array,selected)
    if selected GT 0 then begin; make a region file only if active
        GET_LUN,U & openw,U,regionfilename
        i=frame-1               ;make the target region comes at first
        printf,U, $
          source_table[i].image_x-source_table[frame-1].image_x+dx+1., $
          source_table[i].image_y-source_table[frame-1].image_y+dy+1., $
          source_table[i].spec_mask_dx, $
          source_table[i].spec_mask_dy, $
          0,$                   ; i,$
;         format='("image;box(",I5,",",I5,",",I5,",",I5,",",I5,") # text={",I5,"}")'
         format='("logical; rotbox ",I5,I5,I5,I5,I5)'
        
        for i=0,n_source-1 do begin
            if i NE frame-1 then begin
                select2=where(i EQ use_array-1,selected2)
                if selected2 GT 0 then begin ; make a region file only if active
                    printf,U,$
                      source_table[i].image_x-source_table[frame-1].image_x+dx+1., $
                      source_table[i].image_y-source_table[frame-1].image_y+dy+1., $
                      source_table[i].spec_mask_dx, $
                      source_table[i].spec_mask_dy, $
                      0,$       ; i,$
;                     format='("image;box(",I5,",",I5,",",I5,",",I5,",",I5,") # text={",I5,"}")'
                    format='("logical; rotbox ",I5,I5,I5,I5,I5)'
; add (+1,+1) for FITS viewer whose origin is at (1,1), not at (0,0)
                endif else begin
                    printf,U,format='(" ")' 
                endelse
            endif
        endfor
        close,U & FREE_LUN,U
    endif
    
endfor                          ; of frame loop
end
