pro findmatch,xref,yref,x,y,dx,dy,rot

n=n_elements(x)
rot1=fltarr(n^2)
rot2=fltarr(n^2)
distance=fltarr(n^2)
dx=fltarr(n)
dy=fltarr(n)

for i=0,n-1 do begin
   for j=0,n-1 do begin
      if i NE j then begin
         dx1=x[i]-x[j]
         dy1=y[i]-y[j]

         dx2=xref[i]-xref[j]
         dy2=yref[i]-yref[j]

         rot1[i*j+i]=180./!PI*atan(dy1,dx1)
         rot2[i*j+i]=180./!PI*atan(dy2,dx2)

         distance[i*j+i]=sqrt((y[i]-yref[j])^2.+(x[i]-xref[j])^2.)
      endif
   endfor
   
   dx[i]=x[i]-xref[i]
   dy[i]=y[i]-yref[i]

endfor

;print,rot-rot2
rot=total((rot1-rot2)*distance)/total(distance)
dx=median(dx) & dy=median(dy)

end
