pro get_ds9_region,x,y,title=title,frame=frame

  if ~ defined(title) then begin
     user='_FOR_'+strupcase(getenv('USER'))
     title='IRC_SPECRED'+user
  endif

  if ~ defined(frame) then frame=2 ; to focus on spec image (right half)
  
  spawn,'xpaset -p '+title+' frame '+string(frame)
  spawn,'xpaget '+title+' regions format',original_format
  spawn,'xpaset -p '+title+' regions format xy'
  spawn,'xpaset -p '+title+' regions system image'
  spawn,'xpaget '+title+' regions',result
  
  n_region=n_elements(result)
  x=fltarr(n_region) & y=fltarr(n_region)
  
  for i=0,n_region-1 do begin 
     tmp=strsplit(result[i],' ',/extract)
     x[i]=float(tmp[0])-1.
     y[i]=float(tmp[1])-1.
  endfor
  
  spawn,'xpaset -p '+title+' regions format '+original_format
  
end
