pro interp_nir_shift,dx_nir,dy_nir,dx_mir,dy_mir,short=short

; dx_nir, dy_nir: shift in NIR; dx_mir, dy_mir: shift in MIR

  common GUI,logger

  logger->append,['  calculating offsets among subframes from measured data.']

; pre-process NIR shift
  dx_nir_tmp=dx_nir & dy_nir_tmp=dy_nir

  if SG2() && !IRC_SPECRED_OBSPARAM.AOT NE '04C' then begin ; use NP/NG for SG2 shift
     dx_nir_tmp-=dx_nir_tmp[3] & dy_nir_tmp-=dy_nir_tmp[3]
     dx_nir_tmp=shift(dx_nir_tmp,-4) & dy_nir_tmp=shift(dy_nir_tmp,-4)
     n_dx_nir_tmp=n_elements(dx_nir_tmp)
     if n_dx_nir_tmp GT 4 then begin
;       dx_nir_tmp[4:*]=dx_nir_tmp[3] & dy_nir_tmp[4:*]=dy_nir_tmp[3]
        dx_nir_tmp=dx_nir_tmp[0:n_dx_nir_tmp-4-1] & dy_nir_tmp=dy_nir_tmp[0:n_dx_nir_tmp-4-1]
     endif
  endif
  
;  if SG1() && n_elements(dx_nir_tmp) GT 4 then begin
;    dx_nir_tmp[4,*]=dx_nir_tmp[3] & dy_nir_tmp[4:*]=dy_nir_tmp[3]
  if SG1() then begin
     dx_nir_tmp=dx_nir_tmp[0:3] & dy_nir_tmp=dy_nir_tmp[0:3]
  endif

; do interpolation

  if ( ~ keyword_set(short)) && NIR() EQ 0 then begin
     n_frame_per_NIR=3.
     n_frame=n_elements(dx_nir_tmp)*n_frame_per_NIR ; removing n_frame for SG1
     dx_mir=fltarr(n_frame) & dy_mir=fltarr(n_frame)
     id_nir=findgen(n_elements(dx_nir_tmp))
     id_mir=findgen(n_frame)

     for i=0,n_frame-1 do begin
        linterp,id_nir*n_frame_per_NIR+1.,dx_nir_tmp,id_mir[i],tmp & dx_mir[i]=tmp
        linterp,id_nir*n_frame_per_NIR+1.,dy_nir_tmp,id_mir[i],tmp & dy_mir[i]=tmp
     endfor
     
     if LG2() && !IRC_SPECRED_OBSPARAM.AOT EQ '04C' then begin
                                ; for AOT04C, do the last half of the interporation again
        for i=4*n_frame_per_NIR,n_frame-1 do begin
           linterp,id_nir*n_frame_per_NIR+1.,dx_nir_tmp[4:*],id_mir[i-4*n_frame_per_NIR],tmp & dx_mir[i]=tmp
           linterp,id_nir*n_frame_per_NIR+1.,dy_nir_tmp[4:*],id_mir[i-4*n_frame_per_NIR],tmp & dy_mir[i]=tmp
        endfor
     endif
     
  endif else begin
;  n_frame=n_elements(dx_nir)       ; MIRs short or NIR have 1 frame per NIR frame
;  n_frame_per_NIR=1.
;  for i=0,n_frame-1 do begin
;     linterp,id_nir*n_frame_per_NIR,dx_nir_tmp,id_mir[i],tmp & dx_mir[i]=tmp
;     linterp,id_nir*n_frame_per_NIR,dy_nir_tmp,id_mir[i],tmp & dy_mir[i]=tmp
;  endfor
     dx_mir=dx_nir_tmp & dy_mir=dy_nir_tmp
  endelse
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        facx=1.
        facy=facx
     end
     1: begin
        facx=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirs_x
        facy=!IRC_SPECRED_CHIPINFO.pixscale_nir_y/!IRC_SPECRED_CHIPINFO.pixscale_mirs_y
     end
     2: begin 
        facx=!IRC_SPECRED_CHIPINFO.pixscale_nir_x/!IRC_SPECRED_CHIPINFO.pixscale_mirl_x/1.025
        facy=!IRC_SPECRED_CHIPINFO.pixscale_nir_y/!IRC_SPECRED_CHIPINFO.pixscale_mirl_y/1.025 
     END
  endcase
  
  dx_mir*=facx & dy_mir*=facy
  
;plot,id_mir,dx_mir,psym=5,color=white,xtitle='frame id MIR',ytitle='shift (pix) MIR'
;oplot,id*3+1,dx*facx,psym=5,color=red
  
;oplot,id_mir,dy_mir,psym=4,color=blue
;oplot,id*3+1,dy*facx,psym=4,color=green
  
end
