pro irc_fits_read,image,header,DIR=dir,MYTITLE=mytitle,MYFILTER=myfilter,MYGETPATH=mygetpath

; Use a GUI to select a file (FITS) to be read.
; An image array will be returned as well as its header info.

on_error,2

if keyword_set(dir) EQ 0 then dir='~'
if keyword_set(mytitle) EQ 0 then mytitle='Select a File for READ'
if keyword_set(myfilter) EQ 0 then myfilter='*.fits'

mymytitle=mytitle

fileName = DIALOG_PICKFILE (PATH=dir, FILTER = myfilter,title=mymytitle,get_path=mygetpath)

IF (fileName NE '') THEN BEGIN
    d = FINDFILE (fileName, COUNT = fileExists)
    IF fileExists EQ 0 THEN message,'Error (irc_fits_read): No file found...Stop!'
    image=MRDFITS(fileName,0,header,/silent,/fscale)
endif else begin
    message,'Error (irc_fits_read): No file selected...Stop!'
endelse

end
