PRO irc_imcombine_n,inimage,inimage_short,outimage, $
                    IMAG=IMAG,sky_adjust=sky_adjust, $
                    clip_sig=clip_sig,biweight=biweight,rmsimage=rmsimage,comb_mode=comb_mode,weight=weight, $
                    no_shift=no_shift,dx=dx,dy=dy,follow_NIR=follow_NIR,noisemap_in=noisemap_in

; Combine all frames within same short/long frames
; output: avgimage[x,y,subframe_id], rmsimage[x,y,long_short_id]
;    long_short_id=0 for short & long_short_id=1 for long

  if keyword_set(comb_mode) EQ 0 then comb_mode='average'
  if keyword_set(clip_sig) EQ 0 then clip_sig=3.
  
  get_chip_dims,ncol,nrow
  s=size(inimage) & if s[0] EQ 3 then n_long_frames=s[3] else n_long_frames=1
  s=size(inimage_short) & if s[0] EQ 3 then n_short_frames=s[3] else n_short_frames=1
  
  if keyword_set(weight) EQ 0 then weight=make_array(n_long_frames,/float,value=1.0)
  
  outimage=fltarr(ncol,nrow,2) & rmsimage=fltarr(ncol,nrow,2)  ; 2 for (short, long) frames

  if defined(dx) && defined(dy) then follow_NIR=1
  
  if (keyword_set(no_shift) EQ 0) && (!IRC_SPECRED_OBSPARAM.slit_mode EQ 0B) && (comb_mode NE 'no_combine') then begin
; for long
     do_image_shift,inimage,dx,dy,inimage_shift,follow_NIR=follow_NIR,imag=imag
; for short
     if (keyword_set(IMAG) && !IRC_SPECRED_OBSPARAM.AOT NE '02B') || !IRC_SPECRED_PROCESSOPTION.no_short_mode EQ 1B then $
        inimage_shift_short=inimage_short $
     else begin
        dx_short=dx & dy_short=dy
        do_image_shift,inimage_short,dx_short,dy_short,inimage_shift_short,follow_NIR=follow_NIR,/short
     endelse
  endif else begin
; no shift
     inimage_shift      =inimage
     inimage_shift_short=inimage_short
  endelse
  
  if keyword_set(sky_adjust) then begin
     irc_skyadjust_cube,inimage_shift,      inimage_shift_skyadj
     irc_skyadjust_cube,inimage_shift_short,inimage_shift_skyadj_short
  endif else begin
     inimage_shift_skyadj=      inimage_shift
     inimage_shift_skyadj_short=inimage_shift_short
  endelse
  
  inimage_shift=0B              ; conserve memory
  inimage_shift_short=0B
  
  case comb_mode of
     'no_combine': begin
        rmsimage=fltarr(size(inimage,/dimensions)) ; all zero rms
        outimage=inimage        ; simply copy the input image to output
        return                  ; and exit.
     end
     
     'simple': begin
        rmsimage[*,*,1]=0.
        rmsimage[*,*,0]=0.
        outimage[*,*,1]=total(inimage,3)/n_long_frames
        outimage[*,*,0]=total(inimage_short,3)/n_short_frames
        return
     end
     
     'median': begin
        for y=0,nrow-1 do begin for x=0,ncol-1 do begin
           rmsimage[x,y,1]=robust_sigma_mod(inimage_shift_skyadj[x,y,*])
           rmsimage[x,y,0]=0.   ;robust_sigma_mod(inimage_shift_skyadj_short[x,y,*])
           
           outimage[x,y,1]=median(inimage_shift_skyadj[x,y,*],/even)
           outimage[x,y,0]=median(inimage_shift_skyadj_short[x,y,*],/even)
        endfor & endfor
     end
     
     'average': begin
        for y=0,nrow-1 do begin for x=0,ncol-1 do begin
           use_array=where(finite(inimage_shift_skyadj[x,y,*]) EQ 1,count)
           
           case 1 of
              (count GE 4): begin
; remove for speeding up the process
;                 if keyword_set(biweight) then $
;                    avg=biweight_mean(inimage_shift_skyadj[x,y,use_array],sigma,weight[use_array]) $
;                 else begin
                 if defined(noisemap_in) then $
                    meanclip_mod,inimage_shift_skyadj[x,y,use_array],avg,sigma, $
                                 clipsig=clip_sig,weight=weight[use_array],sigma_set=noisemap_in[x,y]*1. else $
                    meanclip_mod,inimage_shift_skyadj[x,y,use_array],avg,sigma,clipsig=clip_sig,weight=weight[use_array] ;,subs=subs

;                   robomean_mod,inimage_shift_skyadj[x,y,use_array],clip_sig,0.5,avg,avgdev,sigma,var,skew,kurt,nfinal,new,error=error
;                endelse
                 
              end
              (count GE 2 && count LT 4): begin
;                result=moment(inimage_shift_skyadj[x,y,use_array],/NAN)
;                avg=result[0] & sigma=sqrt(result[1])
                 avg=mean(inimage_shift_skyadj[x,y,use_array])
                 sigma=stddev(inimage_shift_skyadj[x,y,use_array])
              end
              (count EQ 1): begin
                 avg=inimage_shift_skyadj[x,y,use_array] & sigma=0.
              end
              else: begin
                 avg=!values.f_nan & sigma=!values.f_nan
              end
           endcase
           
           outimage[x,y,1]=avg         
           rmsimage[x,y,1]=sigma
           
           use_array=where(finite(inimage_short[x,y,*]),count)
           case 1 of
              (count GE 2): begin
;                result=moment(inimage_short[x,y,*])
;                outimage[x,y,0]=result[0]
;                rmsimage[x,y,0]=sqrt(result[1])
                 outimage[x,y,0]=mean(inimage_short[x,y,*])
                 rmsimage[x,y,0]=stddev(inimage_short[x,y,*])
              end
              (count EQ 1): begin
                 outimage[x,y,0]=total(inimage_short[x,y,*],/NAN)
                 rmsimage[x,y,0]=0.
              end
              (count EQ 0): begin
                 outimage[x,y,0]=!values.f_nan
                 rmsimage[x,y,0]=0.
              end
           endcase
           
        endfor & endfor         ; of X, Y loop
        
     end
     
  endcase
  
END
